/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.mac;

import com.gradle.scan.plugin.internal.dep.oshi.jna.Struct;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.mac.MacOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.mac.MacOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.mac.SysctlUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.platform.mac.SystemB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MacOperatingSystemJNA
extends MacOperatingSystem {
    private static final long BOOTTIME;

    public MacOperatingSystemJNA() {
        super(SysctlUtil.sysctl("kern.maxproc", 4096));
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String string = this.major > 10 || this.major == 10 && this.minor >= 12 ? "macOS" : System.getProperty("os.name");
        String string2 = this.parseCodeName();
        String string3 = SysctlUtil.sysctl("kern.osversion", "");
        return new Pair<String, OperatingSystem.OSVersionInfo>(string, new OperatingSystem.OSVersionInfo(this.osXVersion, string2, string3));
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        int[] nArray = new int[this.maxProc];
        Arrays.fill(nArray, -1);
        int n2 = SystemB.INSTANCE.proc_listpids(1, 0, nArray, nArray.length * SystemB.INT_SIZE) / SystemB.INT_SIZE;
        for (int i2 = 0; i2 < n2; ++i2) {
            OSProcess oSProcess;
            if (nArray[i2] < 0 || (oSProcess = this.getProcess(nArray[i2])) == null) continue;
            arrayList.add(oSProcess);
        }
        return arrayList;
    }

    public OSProcess getProcess(int n2) {
        MacOSProcess macOSProcess = new MacOSProcess(n2, this.major, this.minor, this);
        return macOSProcess.getState().equals((Object)OSProcess.State.INVALID) ? null : macOSProcess;
    }

    @Override
    public int getProcessId() {
        return SystemB.INSTANCE.getpid();
    }

    static {
        try (Struct.CloseableTimeval closeableTimeval = new Struct.CloseableTimeval();){
            BOOTTIME = !SysctlUtil.sysctl("kern.boottime", closeableTimeval) || closeableTimeval.tv_sec.longValue() == 0L ? ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : closeableTimeval.tv_sec.longValue();
        }
    }
}

