/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.mac;

import com.gradle.scan.plugin.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.FileUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MacInstalledApps {
    private static final Logger LOG = LoggerFactory.getLogger(MacInstalledApps.class);

    private MacInstalledApps() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        List<String> list = ExecutingCommand.runNative("system_profiler -xml SPApplicationsDataType");
        try {
            List<Map<String, String>> list2 = MacInstalledApps.parseItems(String.join((CharSequence)"", list));
            if (!list2.isEmpty()) {
                LinkedHashSet<ApplicationInfo> linkedHashSet = new LinkedHashSet<ApplicationInfo>();
                for (Map<String, String> map : list2) {
                    try {
                        File file;
                        String string = ParseUtil.getStringValueOrUnknown(map.get("obtained_from"));
                        if ("apple".equals(string)) {
                            string = "Apple";
                        } else if ("mac_app_store".equals(string)) {
                            string = "App Store";
                        }
                        String string2 = ParseUtil.getStringValueOrUnknown(map.get("signed_by"));
                        String string3 = "identified_developer".equals(string) ? (string2.startsWith("Developer ID Application: ") ? string2.substring(26) : string2) : ("unknown".equals(string) && !"unknown".equals(string2) ? string2 : string);
                        String string4 = map.get("version");
                        String string5 = map.get("lastModified");
                        long l2 = ParseUtil.parseDateToEpoch(string5, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        linkedHashMap.put("Kind", ParseUtil.getStringValueOrUnknown(map.get("arch_kind")));
                        String string6 = ParseUtil.getStringValueOrUnknown(map.get("path"));
                        linkedHashMap.put("Location", string6);
                        if (!"unknown".equals(string6) && (file = new File(string6, "/Contents/Info.plist")).exists()) {
                            list = "bplist00".equals(new String(MacInstalledApps.readFirstBytes(file), StandardCharsets.UTF_8)) ? ExecutingCommand.runNative(new String[]{"plutil", "-convert", "xml1", "-o", "-", file.getAbsolutePath()}) : FileUtil.readFile(file.getAbsolutePath());
                            String string7 = String.join((CharSequence)"", list);
                            String string8 = MacInstalledApps.readStringValue(string7, "CFBundleGetInfoString");
                            if (string8 != null && !string8.isEmpty()) {
                                linkedHashMap.put("Get Info String", string8);
                            }
                            if (string4 == null || string4.isEmpty()) {
                                string4 = MacInstalledApps.readStringValue(string7, "CFBundleVersion");
                            }
                        }
                        if (string4 == null || string4.isEmpty()) {
                            string4 = "unknown";
                        }
                        linkedHashSet.add(new ApplicationInfo(map.get("_name"), string4, string3, l2, linkedHashMap));
                    }
                    catch (Exception exception) {
                        LOG.trace("Unable to parse dict values: " + exception.getMessage() + " - " + map, (Throwable)exception);
                    }
                }
                return new ArrayList<ApplicationInfo>(linkedHashSet);
            }
        }
        catch (Exception exception) {
            LOG.trace("Unable to read installed apps: " + exception.getMessage(), (Throwable)exception);
        }
        return Collections.emptyList();
    }

    private static byte[] readFirstBytes(File file) throws IOException {
        byte[] byArray = new byte[8];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    private static List<Map<String, String>> parseItems(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        Matcher matcher = Pattern.compile("<key>\\s*_items\\s*</key>").matcher(string);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        int n2 = string.indexOf("<array>", matcher.end());
        if (n2 < 0) {
            return Collections.emptyList();
        }
        String string2 = MacInstalledApps.extractBalancedInner(string, n2, "<array>", "</array>");
        if (string2 == null) {
            return Collections.emptyList();
        }
        List<String> list = MacInstalledApps.extractTopLevelBlocks(string2, "<dict>", "</dict>");
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (String string3 : list) {
            arrayList.add(MacInstalledApps.parseDict(string3));
        }
        return arrayList;
    }

    private static Map<String, String> parseDict(String string) {
        int n2;
        int n3;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n4 = 0;
        while ((n3 = string.indexOf("<key>", n4)) >= 0 && (n2 = string.indexOf("</key>", n3 + 5)) >= 0) {
            String string2;
            String string3;
            String string4 = MacInstalledApps.unescape(string.substring(n3 + 5, n2).trim());
            int n5 = string.indexOf(60, n2 + 6);
            if (n5 < 0) break;
            if (MacInstalledApps.startsWith(string, n5, "<string>")) {
                string3 = MacInstalledApps.extractSimpleInner(string, n5, "<string>", "</string>");
                string2 = MacInstalledApps.unescape(string3);
                n4 = string.indexOf("</string>", n5) + "</string>".length();
            } else if (MacInstalledApps.startsWith(string, n5, "<date>")) {
                string3 = MacInstalledApps.extractSimpleInner(string, n5, "<date>", "</date>");
                string2 = string3.trim();
                n4 = string.indexOf("</date>", n5) + "</date>".length();
            } else if (MacInstalledApps.startsWith(string, n5, "<array>")) {
                string3 = MacInstalledApps.extractBalancedInner(string, n5, "<array>", "</array>");
                string2 = MacInstalledApps.parseStringArray(string3);
                n4 = string.indexOf("</array>", n5) + "</array>".length();
            } else {
                n4 = n5 + 1;
                continue;
            }
            linkedHashMap.put(string4, string2);
        }
        return linkedHashMap;
    }

    private static String parseStringArray(String string) {
        int n2 = string.indexOf(60);
        if (n2 >= 0 && MacInstalledApps.startsWith(string, n2, "<string>")) {
            String string2 = MacInstalledApps.extractSimpleInner(string, n2, "<string>", "</string>");
            return MacInstalledApps.unescape(string2);
        }
        return null;
    }

    private static boolean startsWith(String string, int n2, String string2) {
        int n3 = n2 + string2.length();
        return n3 <= string.length() && string.regionMatches(false, n2, string2, 0, string2.length());
    }

    private static String extractSimpleInner(String string, int n2, String string2, String string3) {
        int n3 = string.indexOf(string2, n2);
        if (n3 < 0) {
            return "";
        }
        int n4 = string.indexOf(string3, n3 + string2.length());
        if (n4 < 0) {
            return "";
        }
        return string.substring(n3 + string2.length(), n4);
    }

    private static String extractBalancedInner(String string, int n2, String string2, String string3) {
        int n3 = n2;
        if (!MacInstalledApps.startsWith(string, n3, string2)) {
            return null;
        }
        n3 += string2.length();
        int n4 = 1;
        while (n3 < string.length()) {
            int n5 = string.indexOf(string2, n3);
            int n6 = string.indexOf(string3, n3);
            if (n6 == -1) {
                return null;
            }
            if (n5 != -1 && n5 < n6) {
                ++n4;
                n3 = n5 + string2.length();
                continue;
            }
            if (--n4 == 0) {
                return string.substring(n2 + string2.length(), n6);
            }
            n3 = n6 + string3.length();
        }
        return null;
    }

    private static List<String> extractTopLevelBlocks(String string, String string2, String string3) {
        String string4;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        while ((n2 = string.indexOf(string2, n3)) >= 0 && (string4 = MacInstalledApps.extractBalancedInner(string, n2, string2, string3)) != null) {
            int n4;
            arrayList.add(string4);
            n3 = n4 = string.indexOf(string3, n2) + string3.length();
        }
        return arrayList;
    }

    private static String unescape(String string) {
        return string.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&apos;", "'");
    }

    private static String readStringValue(String string, String string2) throws Exception {
        int n2;
        int n3 = string.indexOf("<key>" + string2 + "</key>");
        if (n3 > 0 && (n3 = string.indexOf("<string>", n3)) > 0 && (n2 = string.indexOf("</string>", n3 += 8)) > 0) {
            return string.substring(n3, n2);
        }
        return null;
    }
}

