/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util;

import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;

public abstract class ResourceLeakDetectorFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ResourceLeakDetectorFactory.class);
    private static volatile ResourceLeakDetectorFactory factoryInstance = new DefaultResourceLeakDetectorFactory();

    public static ResourceLeakDetectorFactory instance() {
        return factoryInstance;
    }

    public final <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> clazz) {
        return this.newResourceLeakDetector(clazz, ResourceLeakDetector.SAMPLING_INTERVAL);
    }

    @Deprecated
    public abstract <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> var1, int var2, long var3);

    public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> clazz, int n2) {
        ObjectUtil.checkPositive(n2, "samplingInterval");
        return this.newResourceLeakDetector(clazz, n2, Long.MAX_VALUE);
    }

    private static final class DefaultResourceLeakDetectorFactory
    extends ResourceLeakDetectorFactory {
        private final Constructor<?> obsoleteCustomClassConstructor;
        private final Constructor<?> customClassConstructor;

        DefaultResourceLeakDetectorFactory() {
            String string;
            try {
                string = SystemPropertyUtil.get("com.gradle.scan.plugin.internal.dep.io.netty.customResourceLeakDetector");
            }
            catch (Throwable throwable) {
                logger.error("Could not access System property: io.netty.customResourceLeakDetector", throwable);
                string = null;
            }
            if (string == null) {
                this.customClassConstructor = null;
                this.obsoleteCustomClassConstructor = null;
            } else {
                this.obsoleteCustomClassConstructor = DefaultResourceLeakDetectorFactory.obsoleteCustomClassConstructor(string);
                this.customClassConstructor = DefaultResourceLeakDetectorFactory.customClassConstructor(string);
            }
        }

        private static Constructor<?> obsoleteCustomClassConstructor(String string) {
            try {
                Class<?> clazz = Class.forName(string, true, PlatformDependent.getSystemClassLoader());
                if (ResourceLeakDetector.class.isAssignableFrom(clazz)) {
                    return clazz.getConstructor(Class.class, Integer.TYPE, Long.TYPE);
                }
                logger.error("Class {} does not inherit from ResourceLeakDetector.", (Object)string);
            }
            catch (Throwable throwable) {
                logger.error("Could not load custom resource leak detector class provided: {}", (Object)string, (Object)throwable);
            }
            return null;
        }

        private static Constructor<?> customClassConstructor(String string) {
            try {
                Class<?> clazz = Class.forName(string, true, PlatformDependent.getSystemClassLoader());
                if (ResourceLeakDetector.class.isAssignableFrom(clazz)) {
                    return clazz.getConstructor(Class.class, Integer.TYPE);
                }
                logger.error("Class {} does not inherit from ResourceLeakDetector.", (Object)string);
            }
            catch (Throwable throwable) {
                logger.error("Could not load custom resource leak detector class provided: {}", (Object)string, (Object)throwable);
            }
            return null;
        }

        @Override
        public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> clazz, int n2, long l2) {
            if (this.obsoleteCustomClassConstructor != null) {
                try {
                    ResourceLeakDetector resourceLeakDetector = (ResourceLeakDetector)this.obsoleteCustomClassConstructor.newInstance(clazz, n2, l2);
                    logger.debug("Loaded custom ResourceLeakDetector: {}", (Object)this.obsoleteCustomClassConstructor.getDeclaringClass().getName());
                    return resourceLeakDetector;
                }
                catch (Throwable throwable) {
                    logger.error("Could not load custom resource leak detector provided: {} with the given resource: {}", this.obsoleteCustomClassConstructor.getDeclaringClass().getName(), clazz, throwable);
                }
            }
            ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector(clazz, n2, l2);
            logger.debug("Loaded default ResourceLeakDetector: {}", (Object)resourceLeakDetector);
            return resourceLeakDetector;
        }

        @Override
        public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> clazz, int n2) {
            if (this.customClassConstructor != null) {
                try {
                    ResourceLeakDetector resourceLeakDetector = (ResourceLeakDetector)this.customClassConstructor.newInstance(clazz, n2);
                    logger.debug("Loaded custom ResourceLeakDetector: {}", (Object)this.customClassConstructor.getDeclaringClass().getName());
                    return resourceLeakDetector;
                }
                catch (Throwable throwable) {
                    logger.error("Could not load custom resource leak detector provided: {} with the given resource: {}", this.customClassConstructor.getDeclaringClass().getName(), clazz, throwable);
                }
            }
            ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector(clazz, n2);
            logger.debug("Loaded default ResourceLeakDetector: {}", (Object)resourceLeakDetector);
            return resourceLeakDetector;
        }
    }
}

