/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.idea.events;

import com.gradle.idea.events.d;
import com.gradle.idea.events.e;
import com.gradle.obfuscation.Keep;
import com.gradle.scan.agent.serialization.scan.a.k;
import com.gradle.scan.agent.serialization.scan.a.l;
import com.gradle.scan.eventmodel.EventData;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Keep
class EventDataDeserializer
extends JsonDeserializer<EventData> {
    private static final Set<String> ALLOWED_EVENT_TYPES = Stream.concat(Stream.concat(Stream.of(k.values()).map(k::e), Stream.of(d.values()).map(d::a)), Stream.concat(Stream.of(l.values()).map(l::e), Stream.of(e.values()).map(e::a))).map(Class::getName).collect(Collectors.toSet());

    EventDataDeserializer() {
    }

    @Override
    public EventData deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        try {
            JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
            String string = jsonNode.get("clazz").asText();
            if (!ALLOWED_EVENT_TYPES.contains(string)) {
                throw new IllegalArgumentException("Unknown event type, cannot deserialize event: " + string);
            }
            Class<?> clazz = Class.forName(string);
            JsonNode jsonNode2 = jsonNode.get("object");
            return (EventData)jsonParser.getCodec().treeToValue(jsonNode2, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

