/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.windows;

import com.gradle.scan.plugin.internal.dep.oshi.driver.windows.registry.ProcessPerformanceData;
import com.gradle.scan.plugin.internal.dep.oshi.driver.windows.registry.ProcessWtsData;
import com.gradle.scan.plugin.internal.dep.oshi.driver.windows.registry.ThreadPerformanceData;
import com.gradle.scan.plugin.internal.dep.oshi.driver.windows.wmi.Win32OperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.driver.windows.wmi.Win32Processor;
import com.gradle.scan.plugin.internal.dep.oshi.jna.ByRef;
import com.gradle.scan.plugin.internal.dep.oshi.jna.Struct;
import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.windows.WindowsInstalledApps;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.windows.WindowsOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.util.GlobalConfig;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.windows.WmiUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOperatingSystem.class);
    private static final boolean USE_PROCSTATE_SUSPENDED = GlobalConfig.get("com.gradle.scan.plugin.internal.dep.oshi.os.windows.procstate.suspended", false);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static Supplier<String> systemLog = Memoizer.memoize(WindowsOperatingSystem::querySystemLog, TimeUnit.HOURS.toNanos(1L));
    private static final long BOOTTIME = WindowsOperatingSystem.querySystemBootTime();
    private static final boolean X86;
    private static final boolean WOW;
    private final Supplier<List<ApplicationInfo>> installedAppsSupplier = Memoizer.memoize(WindowsInstalledApps::queryInstalledApps, Memoizer.installedAppsExpiration());
    private Supplier<Map<Integer, ProcessPerformanceData.PerfCounterBlock>> processMapFromRegistry = Memoizer.memoize(WindowsOperatingSystem::queryProcessMapFromRegistry, Memoizer.defaultExpiration());
    private Supplier<Map<Integer, ProcessPerformanceData.PerfCounterBlock>> processMapFromPerfCounters = Memoizer.memoize(WindowsOperatingSystem::queryProcessMapFromPerfCounters, Memoizer.defaultExpiration());
    private Supplier<Map<Integer, ThreadPerformanceData.PerfCounterBlock>> threadMapFromRegistry = Memoizer.memoize(WindowsOperatingSystem::queryThreadMapFromRegistry, Memoizer.defaultExpiration());
    private Supplier<Map<Integer, ThreadPerformanceData.PerfCounterBlock>> threadMapFromPerfCounters = Memoizer.memoize(WindowsOperatingSystem::queryThreadMapFromPerfCounters, Memoizer.defaultExpiration());

    @Override
    public String queryManufacturer() {
        return "Microsoft";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows ")) {
            string = string.substring(8);
        }
        String string2 = null;
        int n2 = 0;
        String string3 = "";
        WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> wmiResult = Win32OperatingSystem.queryOsVersion();
        if (wmiResult.getResultCount() > 0) {
            string2 = WmiUtil.getString(wmiResult, Win32OperatingSystem.OSVersionProperty.CSDVERSION, 0);
            if (!string2.isEmpty() && !"unknown".equals(string2)) {
                string = string + " " + string2.replace("Service Pack ", "SP");
            }
            n2 = WmiUtil.getUint32(wmiResult, Win32OperatingSystem.OSVersionProperty.SUITEMASK, 0);
            string3 = WmiUtil.getString(wmiResult, Win32OperatingSystem.OSVersionProperty.BUILDNUMBER, 0);
        }
        String string4 = WindowsOperatingSystem.parseCodeName(n2);
        if ("10".equals(string) && string3.compareTo("22000") >= 0) {
            string = "11";
        }
        if ("Server 2016".equals(string) && string3.compareTo("17762") > 0) {
            string = "Server 2019";
        }
        if ("Server 2019".equals(string) && string3.compareTo("20347") > 0) {
            string = "Server 2022";
        }
        if ("Server 2022".equals(string) && string3.compareTo("26039") > 0) {
            string = "Server 2025";
        }
        return new Pair<String, OperatingSystem.OSVersionInfo>("Windows", new OperatingSystem.OSVersionInfo(string, string4, string3));
    }

    private static String parseCodeName(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n2 & 2) != 0) {
            arrayList.add("Enterprise");
        }
        if ((n2 & 4) != 0) {
            arrayList.add("BackOffice");
        }
        if ((n2 & 8) != 0) {
            arrayList.add("Communications Server");
        }
        if ((n2 & 0x80) != 0) {
            arrayList.add("Datacenter");
        }
        if ((n2 & 0x200) != 0) {
            arrayList.add("Home");
        }
        if ((n2 & 0x400) != 0) {
            arrayList.add("Web Server");
        }
        if ((n2 & 0x2000) != 0) {
            arrayList.add("Storage Server");
        }
        if ((n2 & 0x4000) != 0) {
            arrayList.add("Compute Cluster");
        }
        if ((n2 & 0x8000) != 0) {
            arrayList.add("Home Server");
        }
        return String.join((CharSequence)",", arrayList);
    }

    @Override
    protected int queryBitness(int n2) {
        WbemcliUtil.WmiResult<Win32Processor.BitnessProperty> wmiResult;
        if (n2 < 64 && System.getenv("ProgramFiles(x86)") != null && IS_VISTA_OR_GREATER && (wmiResult = Win32Processor.queryBitness()).getResultCount() > 0) {
            return WmiUtil.getUint16(wmiResult, Win32Processor.BitnessProperty.ADDRESSWIDTH, 0);
        }
        return n2;
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.processMapToList(null);
    }

    private List<OSProcess> processMapToList(Collection<Integer> collection) {
        Map<Integer, ProcessPerformanceData.PerfCounterBlock> map = this.processMapFromRegistry.get();
        if (map == null || map.isEmpty()) {
            map = collection == null ? this.processMapFromPerfCounters.get() : ProcessPerformanceData.buildProcessMapFromPerfCounters(collection);
        }
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> map2 = null;
        if (USE_PROCSTATE_SUSPENDED && ((map2 = this.threadMapFromRegistry.get()) == null || map2.isEmpty())) {
            map2 = collection == null ? this.threadMapFromPerfCounters.get() : ThreadPerformanceData.buildThreadMapFromPerfCounters(collection);
        }
        Map<Integer, ProcessWtsData.WtsInfo> map3 = ProcessWtsData.queryProcessWtsMap(collection);
        HashSet<Integer> hashSet = new HashSet<Integer>(map3.keySet());
        hashSet.retainAll(map.keySet());
        Map<Integer, ProcessPerformanceData.PerfCounterBlock> map4 = map;
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> map5 = map2;
        return ((Stream)hashSet.stream().parallel()).map(n2 -> new WindowsOSProcess((int)n2, this, map4, map3, map5)).filter(OperatingSystem.ProcessFiltering.VALID_PROCESS).collect(Collectors.toList());
    }

    private static Map<Integer, ProcessPerformanceData.PerfCounterBlock> queryProcessMapFromRegistry() {
        return ProcessPerformanceData.buildProcessMapFromRegistry(null);
    }

    private static Map<Integer, ProcessPerformanceData.PerfCounterBlock> queryProcessMapFromPerfCounters() {
        return ProcessPerformanceData.buildProcessMapFromPerfCounters(null);
    }

    private static Map<Integer, ThreadPerformanceData.PerfCounterBlock> queryThreadMapFromRegistry() {
        return ThreadPerformanceData.buildThreadMapFromRegistry(null);
    }

    private static Map<Integer, ThreadPerformanceData.PerfCounterBlock> queryThreadMapFromPerfCounters() {
        return ThreadPerformanceData.buildThreadMapFromPerfCounters(null);
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    private static long querySystemUptime() {
        if (IS_VISTA_OR_GREATER) {
            return Kernel32.INSTANCE.GetTickCount64() / 1000L;
        }
        return (long)Kernel32.INSTANCE.GetTickCount() / 1000L;
    }

    private static long querySystemBootTime() {
        String string = systemLog.get();
        if (string != null) {
            try {
                Advapi32Util.EventLogIterator eventLogIterator = new Advapi32Util.EventLogIterator(null, string, 8);
                long l2 = 0L;
                while (eventLogIterator.hasNext()) {
                    Advapi32Util.EventLogRecord eventLogRecord = eventLogIterator.next();
                    if (eventLogRecord.getStatusCode() == 12) {
                        return eventLogRecord.getRecord().TimeGenerated.longValue();
                    }
                    if (eventLogRecord.getStatusCode() != 6005) continue;
                    if (l2 > 0L) {
                        return l2;
                    }
                    l2 = eventLogRecord.getRecord().TimeGenerated.longValue();
                }
                if (l2 > 0L) {
                    return l2;
                }
            }
            catch (Win32Exception win32Exception) {
                LOG.warn("Can't open event log \"{}\".", (Object)string);
            }
        }
        return System.currentTimeMillis() / 1000L - WindowsOperatingSystem.querySystemUptime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean enableDebugPrivilege() {
        try (ByRef.CloseableHANDLEByReference closeableHANDLEByReference = new ByRef.CloseableHANDLEByReference();){
            boolean bl2 = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, closeableHANDLEByReference);
            if (!bl2) {
                LOG.error("OpenProcessToken failed. Error: {}", (Object)Native.getLastError());
                boolean bl3 = false;
                return bl3;
            }
            try {
                WinNT.LUID lUID = new WinNT.LUID();
                bl2 = Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", lUID);
                if (!bl2) {
                    LOG.error("LookupPrivilegeValue failed. Error: {}", (Object)Native.getLastError());
                    boolean bl4 = false;
                    return bl4;
                }
                WinNT.TOKEN_PRIVILEGES tOKEN_PRIVILEGES = new WinNT.TOKEN_PRIVILEGES(1);
                tOKEN_PRIVILEGES.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(lUID, new WinDef.DWORD(2L));
                bl2 = Advapi32.INSTANCE.AdjustTokenPrivileges(closeableHANDLEByReference.getValue(), false, tOKEN_PRIVILEGES, 0, null, null);
                int n2 = Native.getLastError();
                if (!bl2) {
                    LOG.error("AdjustTokenPrivileges failed. Error: {}", (Object)n2);
                    boolean bl5 = false;
                    return bl5;
                }
                if (n2 != 1300) return true;
                LOG.debug("Debug privileges not enabled.");
                boolean bl6 = false;
                return bl6;
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(closeableHANDLEByReference.getValue());
            }
        }
    }

    private static String querySystemLog() {
        String string = GlobalConfig.get("com.gradle.scan.plugin.internal.dep.oshi.os.windows.eventlog", "System");
        if (string.isEmpty()) {
            return null;
        }
        WinNT.HANDLE hANDLE = Advapi32.INSTANCE.OpenEventLog(null, string);
        if (hANDLE == null) {
            LOG.warn("Unable to open configured system Event log \"{}\". Calculating boot time from uptime.", (Object)string);
            return null;
        }
        return string;
    }

    static boolean isX86() {
        return X86;
    }

    private static boolean isCurrentX86() {
        try (Struct.CloseableSystemInfo closeableSystemInfo = new Struct.CloseableSystemInfo();){
            Kernel32.INSTANCE.GetNativeSystemInfo(closeableSystemInfo);
            boolean bl2 = 0 == closeableSystemInfo.processorArchitecture.pi.wProcessorArchitecture.intValue();
            return bl2;
        }
    }

    static boolean isWow(WinNT.HANDLE hANDLE) {
        if (X86) {
            return true;
        }
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
            Kernel32.INSTANCE.IsWow64Process(hANDLE, closeableIntByReference);
            boolean bl2 = closeableIntByReference.getValue() != 0;
            return bl2;
        }
    }

    private static boolean isCurrentWow() {
        if (X86) {
            return true;
        }
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.GetCurrentProcess();
        return hANDLE == null ? false : WindowsOperatingSystem.isWow(hANDLE);
    }

    static {
        WindowsOperatingSystem.enableDebugPrivilege();
        X86 = WindowsOperatingSystem.isCurrentX86();
        WOW = WindowsOperatingSystem.isCurrentWow();
    }
}

