/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelOutboundHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.MessageToMessageDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.PromiseNotifier;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame>
implements ChannelOutboundHandler {
    private final boolean dropPongFrames;
    private final WebSocketCloseStatus closeStatus;
    private final long forceCloseTimeoutMillis;
    private ChannelPromise closeSent;

    WebSocketProtocolHandler(boolean bl2, WebSocketCloseStatus webSocketCloseStatus, long l2) {
        super(WebSocketFrame.class);
        this.dropPongFrames = bl2;
        this.closeStatus = webSocketCloseStatus;
        this.forceCloseTimeoutMillis = l2;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) throws Exception {
        if (webSocketFrame instanceof PingWebSocketFrame) {
            webSocketFrame.content().retain();
            channelHandlerContext.writeAndFlush(new PongWebSocketFrame(webSocketFrame.content()));
            WebSocketProtocolHandler.readIfNeeded(channelHandlerContext);
            return;
        }
        if (webSocketFrame instanceof PongWebSocketFrame && this.dropPongFrames) {
            WebSocketProtocolHandler.readIfNeeded(channelHandlerContext);
            return;
        }
        list.add(webSocketFrame.retain());
    }

    private static void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
    }

    @Override
    public void close(final ChannelHandlerContext channelHandlerContext, final ChannelPromise channelPromise) throws Exception {
        if (this.closeStatus == null || !channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
        } else {
            if (this.closeSent == null) {
                this.write(channelHandlerContext, new CloseWebSocketFrame(this.closeStatus), channelHandlerContext.newPromise());
            }
            this.flush(channelHandlerContext);
            this.applyCloseSentTimeout(channelHandlerContext);
            this.closeSent.addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture) {
                    channelHandlerContext.close(channelPromise);
                }
            });
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (this.closeSent != null) {
            ReferenceCountUtil.release(object);
            channelPromise.setFailure(new ClosedChannelException());
        } else if (object instanceof CloseWebSocketFrame) {
            this.closeSent(channelPromise.unvoid());
            channelHandlerContext.write(object).addListener((GenericFutureListener)new PromiseNotifier(false, this.closeSent));
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    void closeSent(ChannelPromise channelPromise) {
        this.closeSent = channelPromise;
    }

    private void applyCloseSentTimeout(ChannelHandlerContext channelHandlerContext) {
        if (this.closeSent.isDone() || this.forceCloseTimeoutMillis < 0L) {
            return;
        }
        ScheduledFuture scheduledFuture = channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!WebSocketProtocolHandler.this.closeSent.isDone()) {
                    WebSocketProtocolHandler.this.closeSent.tryFailure(WebSocketProtocolHandler.this.buildHandshakeException("send close frame timed out"));
                }
            }
        }, this.forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
        this.closeSent.addListener((GenericFutureListener)new ChannelFutureListener((Future)((Object)scheduledFuture)){
            final /* synthetic */ Future val$timeoutTask;
            {
                this.val$timeoutTask = future;
            }

            @Override
            public void operationComplete(ChannelFuture channelFuture) {
                this.val$timeoutTask.cancel(false);
            }
        });
    }

    protected WebSocketHandshakeException buildHandshakeException(String string) {
        return new WebSocketHandshakeException(string);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.read();
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        channelHandlerContext.fireExceptionCaught(throwable);
        channelHandlerContext.close();
    }
}

