/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.impl;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DatabindContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    protected final MapperConfig<?> _config;
    protected final ConcurrentHashMap<String, String> _typeToId;
    protected final Map<String, JavaType> _idToType;
    protected final boolean _caseInsensitive;

    protected SimpleNameIdResolver(MapperConfig<?> mapperConfig, JavaType javaType, ConcurrentHashMap<String, String> concurrentHashMap, HashMap<String, JavaType> hashMap) {
        super(javaType, mapperConfig.getTypeFactory());
        this._config = mapperConfig;
        this._typeToId = concurrentHashMap;
        this._idToType = hashMap;
        this._caseInsensitive = mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
    }

    public static SimpleNameIdResolver construct(MapperConfig<?> mapperConfig, JavaType javaType, Collection<NamedType> collection, boolean bl2, boolean bl3) {
        HashMap<String, JavaType> hashMap;
        ConcurrentHashMap<String, String> concurrentHashMap;
        if (bl2 == bl3) {
            throw new IllegalArgumentException();
        }
        if (bl2) {
            concurrentHashMap = new ConcurrentHashMap<String, String>();
            hashMap = null;
        } else {
            hashMap = new HashMap<String, JavaType>();
            concurrentHashMap = new ConcurrentHashMap(4);
        }
        boolean bl4 = mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
        if (collection != null) {
            for (NamedType namedType : collection) {
                JavaType javaType2;
                String string;
                Class<?> clazz = namedType.getType();
                String string2 = string = namedType.hasName() ? namedType.getName() : SimpleNameIdResolver._defaultTypeId(clazz);
                if (bl2) {
                    concurrentHashMap.put(clazz.getName(), string);
                }
                if (!bl3) continue;
                if (bl4) {
                    string = string.toLowerCase();
                }
                if ((javaType2 = hashMap.get(string)) != null && clazz.isAssignableFrom(javaType2.getRawClass())) continue;
                hashMap.put(string, mapperConfig.constructType(clazz));
            }
        }
        return new SimpleNameIdResolver(mapperConfig, javaType, concurrentHashMap, hashMap);
    }

    @Override
    public String idFromValue(Object object) {
        return this.idFromClass(object.getClass());
    }

    protected String idFromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String string = (clazz = this._resolveToParentAsNecessary(clazz)).getName();
        String string2 = this._typeToId.get(string);
        if (string2 == null) {
            Class<?> clazz2 = this._typeFactory.constructType(clazz).getRawClass();
            if (this._config.isAnnotationProcessingEnabled()) {
                BeanDescription beanDescription = this._config.introspectClassAnnotations(clazz2);
                string2 = this._config.getAnnotationIntrospector().findTypeName(beanDescription.getClassInfo());
            }
            if (string2 == null) {
                string2 = SimpleNameIdResolver._defaultTypeId(clazz2);
            }
            this._typeToId.put(string, string2);
        }
        return string2;
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        if (object == null) {
            return this.idFromClass(clazz);
        }
        return this.idFromValue(object);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) {
        return this._typeFromId(string);
    }

    protected JavaType _typeFromId(String string) {
        if (this._caseInsensitive) {
            string = string.toLowerCase();
        }
        return this._idToType.get(string);
    }

    @Override
    public String getDescForKnownTypeIds() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry<String, JavaType> entry : this._idToType.entrySet()) {
            if (!entry.getValue().isConcrete()) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet.toString();
    }

    public String toString() {
        return String.format("[%s; id-to-type=%s]", this.getClass().getName(), this._idToType);
    }

    protected static String _defaultTypeId(Class<?> clazz) {
        String string = clazz.getName();
        int n2 = Math.max(string.lastIndexOf(46), string.lastIndexOf(36));
        return n2 < 0 ? string : string.substring(n2 + 1);
    }
}

