/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.solaris;

import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.solaris.kstat.SystemPages;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.common.AbstractVirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.solaris.SolarisGlobalMemory;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SolarisVirtualMemory
extends AbstractVirtualMemory {
    private static final Pattern SWAP_INFO = Pattern.compile(".+\\s(\\d+)K\\s+(\\d+)K$");
    private final SolarisGlobalMemory global;
    private final Supplier<Pair<Long, Long>> availTotal = Memoizer.memoize(SystemPages::queryAvailableTotal, Memoizer.defaultExpiration());
    private final Supplier<Pair<Long, Long>> usedTotal = Memoizer.memoize(SolarisVirtualMemory::querySwapInfo, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesIn = Memoizer.memoize(SolarisVirtualMemory::queryPagesIn, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesOut = Memoizer.memoize(SolarisVirtualMemory::queryPagesOut, Memoizer.defaultExpiration());

    SolarisVirtualMemory(SolarisGlobalMemory solarisGlobalMemory) {
        this.global = solarisGlobalMemory;
    }

    @Override
    public long getSwapUsed() {
        return this.usedTotal.get().getA();
    }

    @Override
    public long getSwapTotal() {
        return this.usedTotal.get().getB();
    }

    @Override
    public long getVirtualMax() {
        return this.global.getPageSize() * this.availTotal.get().getB() + this.getSwapTotal();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getPageSize() * (this.availTotal.get().getB() - this.availTotal.get().getA()) + this.getSwapUsed();
    }

    private static long queryPagesIn() {
        long l2 = 0L;
        for (String string : ExecutingCommand.runNative("kstat -p cpu_stat:::pgswapin")) {
            l2 += ParseUtil.parseLastLong(string, 0L);
        }
        return l2;
    }

    private static long queryPagesOut() {
        long l2 = 0L;
        for (String string : ExecutingCommand.runNative("kstat -p cpu_stat:::pgswapout")) {
            l2 += ParseUtil.parseLastLong(string, 0L);
        }
        return l2;
    }

    private static Pair<Long, Long> querySwapInfo() {
        long l2 = 0L;
        long l3 = 0L;
        String string = ExecutingCommand.getAnswerAt("swap -lk", 1);
        Matcher matcher = SWAP_INFO.matcher(string);
        if (matcher.matches()) {
            l2 = ParseUtil.parseLongOrDefault(matcher.group(1), 0L) << 10;
            l3 = l2 - (ParseUtil.parseLongOrDefault(matcher.group(2), 0L) << 10);
        }
        return new Pair<Long, Long>(l3, l2);
    }
}

