/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public final class BoundedInputStream
extends FilterInputStream {
    private final int maxBytesRead;
    private int numRead;

    public BoundedInputStream(@NotNull InputStream inputStream, int n2) {
        super(inputStream);
        this.maxBytesRead = ObjectUtil.checkPositive(n2, "maxRead");
    }

    public BoundedInputStream(@NotNull InputStream inputStream) {
        this(inputStream, 8192);
    }

    @Override
    public int read() throws IOException {
        this.checkMaxBytesRead();
        int n2 = super.read();
        if (n2 != -1) {
            ++this.numRead;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkMaxBytesRead();
        int n4 = Math.min(n3, this.maxBytesRead - this.numRead + 1);
        int n5 = super.read(byArray, n2, n4);
        if (n5 != -1) {
            this.numRead += n5;
        }
        return n5;
    }

    private void checkMaxBytesRead() throws IOException {
        if (this.numRead > this.maxBytesRead) {
            throw new IOException("Maximum number of bytes read: " + this.numRead);
        }
    }
}

