/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Hashing;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.JdkBackedImmutableSet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.RegularImmutableAsList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.RegularImmutableSet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Sets;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.SingletonImmutableSet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableIterator;
import com.gradle.scan.plugin.internal.dep.com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E e2) {
        return new SingletonImmutableSet<E>(e2);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        Preconditions.checkArgument(EArray.length <= 0x7FFFFFF9, "the total number of elements must fit in an int");
        SetBuilderImpl setBuilderImpl = new RegularSetBuilderImpl<E>(6 + EArray.length);
        setBuilderImpl = setBuilderImpl.add(e2).add(e3).add(e4).add(e5).add(e6).add(e7);
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            setBuilderImpl = setBuilderImpl.add(EArray[i2]);
        }
        return setBuilderImpl.review().build();
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    static int chooseTableSize(int n2) {
        if ((n2 = Math.max(n2, 2)) < 0x2CCCCCCC) {
            int n3 = Integer.highestOneBit(n2 - 1) << 1;
            while ((double)n3 * 0.7 < (double)n2) {
                n3 <<= 1;
            }
            return n3;
        }
        Preconditions.checkArgument(n2 < 0x40000000, "collection too large");
        return 0x40000000;
    }

    private static final class RegularSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private Object[] hashTable = null;
        private int maxRunBeforeFallback = 0;
        private int expandTableThreshold = 0;
        private int hashCode;

        RegularSetBuilderImpl(int n2) {
            super(n2);
        }

        @Override
        SetBuilderImpl<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            if (this.hashTable == null) {
                if (this.distinct == 0) {
                    this.addDedupedElement(e2);
                    return this;
                }
                this.ensureTableCapacity(this.dedupedElements.length);
                Object object = this.dedupedElements[0];
                --this.distinct;
                return this.insertInHashTable(object).add(e2);
            }
            return this.insertInHashTable(e2);
        }

        private SetBuilderImpl<E> insertInHashTable(E e2) {
            Objects.requireNonNull(this.hashTable);
            int n2 = e2.hashCode();
            int n3 = Hashing.smear(n2);
            int n4 = this.hashTable.length - 1;
            int n5 = n3;
            while (n5 - n3 < this.maxRunBeforeFallback) {
                int n6 = n5 & n4;
                Object object = this.hashTable[n6];
                if (object == null) {
                    this.addDedupedElement(e2);
                    this.hashTable[n6] = e2;
                    this.hashCode += n2;
                    this.ensureTableCapacity(this.distinct);
                    return this;
                }
                if (object.equals(e2)) {
                    return this;
                }
                ++n5;
            }
            return new JdkBackedSetBuilderImpl<E>(this).add(e2);
        }

        @Override
        SetBuilderImpl<E> review() {
            if (this.hashTable == null) {
                return this;
            }
            int n2 = ImmutableSet.chooseTableSize(this.distinct);
            if (n2 * 2 < this.hashTable.length) {
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(n2, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(n2);
                this.expandTableThreshold = (int)(0.7 * (double)n2);
            }
            return RegularSetBuilderImpl.hashFloodingDetected(this.hashTable) ? new JdkBackedSetBuilderImpl(this) : this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            Object[] objectArray = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf(this.dedupedElements, this.distinct);
            return new RegularImmutableSet(objectArray, this.hashCode, Objects.requireNonNull(this.hashTable), this.hashTable.length - 1);
        }

        static Object[] rebuildHashTable(int n2, Object[] objectArray, int n3) {
            Object[] objectArray2 = new Object[n2];
            int n4 = objectArray2.length - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5;
                Object object = Objects.requireNonNull(objectArray[i2]);
                int n6 = n5 = Hashing.smear(object.hashCode());
                while (true) {
                    int n7;
                    if (objectArray2[n7 = n6 & n4] == null) break;
                    ++n6;
                }
                objectArray2[n7] = object;
            }
            return objectArray2;
        }

        void ensureTableCapacity(int n2) {
            int n3;
            if (this.hashTable == null) {
                n3 = ImmutableSet.chooseTableSize(n2);
                this.hashTable = new Object[n3];
            } else if (n2 > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                n3 = this.hashTable.length * 2;
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(n3, this.dedupedElements, this.distinct);
            } else {
                return;
            }
            this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(n3);
            this.expandTableThreshold = (int)(0.7 * (double)n3);
        }

        static boolean hashFloodingDetected(Object[] objectArray) {
            int n2 = RegularSetBuilderImpl.maxRunBeforeFallback(objectArray.length);
            int n3 = objectArray.length - 1;
            int n4 = 0;
            int n5 = 0;
            block0: while (n4 < objectArray.length) {
                if (n4 == n5 && objectArray[n4] == null) {
                    if (objectArray[n4 + n2 - 1 & n3] == null) {
                        n4 += n2;
                    }
                    n5 = ++n4;
                    continue;
                }
                for (int i2 = n4 + n2 - 1; i2 >= n5; --i2) {
                    if (objectArray[i2 & n3] != null) continue;
                    n5 = n4 + n2;
                    n4 = i2 + 1;
                    continue block0;
                }
                return true;
            }
            return false;
        }

        static int maxRunBeforeFallback(int n2) {
            return 13 * IntMath.log2(n2, RoundingMode.UNNECESSARY);
        }
    }

    private static abstract class SetBuilderImpl<E> {
        E[] dedupedElements;
        int distinct;

        SetBuilderImpl(int n2) {
            this.dedupedElements = new Object[n2];
            this.distinct = 0;
        }

        SetBuilderImpl(SetBuilderImpl<E> setBuilderImpl) {
            this.dedupedElements = Arrays.copyOf(setBuilderImpl.dedupedElements, setBuilderImpl.dedupedElements.length);
            this.distinct = setBuilderImpl.distinct;
        }

        private void ensureCapacity(int n2) {
            if (n2 > this.dedupedElements.length) {
                int n3 = ImmutableCollection.Builder.expandedCapacity(this.dedupedElements.length, n2);
                this.dedupedElements = Arrays.copyOf(this.dedupedElements, n3);
            }
        }

        final void addDedupedElement(E e2) {
            this.ensureCapacity(this.distinct + 1);
            this.dedupedElements[this.distinct++] = e2;
        }

        abstract SetBuilderImpl<E> add(E var1);

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    private static final class JdkBackedSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private final Set<Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> setBuilderImpl) {
            super(setBuilderImpl);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i2 = 0; i2 < this.distinct; ++i2) {
                this.delegate.add(Objects.requireNonNull(this.dedupedElements[i2]));
            }
        }

        @Override
        SetBuilderImpl<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            if (this.delegate.add(e2)) {
                this.addDedupedElement(e2);
            }
            return this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    static abstract class CachingAsList<E>
    extends ImmutableSet<E> {
        private transient ImmutableList<E> asList;

        CachingAsList() {
        }

        @Override
        public ImmutableList<E> asList() {
            ImmutableList<E> immutableList = this.asList;
            if (immutableList == null) {
                this.asList = this.createAsList();
                return this.asList;
            }
            return immutableList;
        }

        ImmutableList<E> createAsList() {
            return new RegularImmutableAsList(this, this.toArray());
        }
    }
}

