/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolArena;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolChunk;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolChunkListMetric;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolChunkMetric;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolThreadCache;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PooledByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

final class PoolChunkList<T>
implements PoolChunkListMetric {
    private static final Iterator<PoolChunkMetric> EMPTY_METRICS = Collections.emptyIterator();
    private final PoolArena<T> arena;
    private final PoolChunkList<T> nextList;
    private final int minUsage;
    private final int maxUsage;
    private final int maxCapacity;
    private PoolChunk<T> head;
    private final int freeMinThreshold;
    private final int freeMaxThreshold;
    private PoolChunkList<T> prevList;

    PoolChunkList(PoolArena<T> poolArena, PoolChunkList<T> poolChunkList, int n2, int n3, int n4) {
        assert (n2 <= n3);
        this.arena = poolArena;
        this.nextList = poolChunkList;
        this.minUsage = n2;
        this.maxUsage = n3;
        this.maxCapacity = PoolChunkList.calculateMaxCapacity(n2, n4);
        this.freeMinThreshold = n3 == 100 ? 0 : (int)((double)n4 * (100.0 - (double)n3 + 0.99999999) / 100.0);
        this.freeMaxThreshold = n2 == 100 ? 0 : (int)((double)n4 * (100.0 - (double)n2 + 0.99999999) / 100.0);
    }

    private static int calculateMaxCapacity(int n2, int n3) {
        if ((n2 = PoolChunkList.minUsage0(n2)) == 100) {
            return 0;
        }
        return (int)((long)n3 * (100L - (long)n2) / 100L);
    }

    void prevList(PoolChunkList<T> poolChunkList) {
        assert (this.prevList == null);
        this.prevList = poolChunkList;
    }

    boolean allocate(PooledByteBuf<T> pooledByteBuf, int n2, int n3, PoolThreadCache poolThreadCache) {
        int n4 = this.arena.sizeClass.sizeIdx2size(n3);
        if (n4 > this.maxCapacity) {
            return false;
        }
        PoolChunk<T> poolChunk = this.head;
        while (poolChunk != null) {
            if (poolChunk.allocate(pooledByteBuf, n2, n3, poolThreadCache)) {
                if (poolChunk.freeBytes <= this.freeMinThreshold) {
                    this.remove(poolChunk);
                    this.nextList.add(poolChunk);
                }
                return true;
            }
            poolChunk = poolChunk.next;
        }
        return false;
    }

    boolean free(PoolChunk<T> poolChunk, long l2, int n2, ByteBuffer byteBuffer) {
        poolChunk.free(l2, n2, byteBuffer);
        if (poolChunk.freeBytes > this.freeMaxThreshold) {
            this.remove(poolChunk);
            return this.move0(poolChunk);
        }
        return true;
    }

    private boolean move(PoolChunk<T> poolChunk) {
        assert (poolChunk.usage() < this.maxUsage);
        if (poolChunk.freeBytes > this.freeMaxThreshold) {
            return this.move0(poolChunk);
        }
        this.add0(poolChunk);
        return true;
    }

    private boolean move0(PoolChunk<T> poolChunk) {
        if (this.prevList == null) {
            assert (poolChunk.usage() == 0);
            return false;
        }
        return super.move(poolChunk);
    }

    void add(PoolChunk<T> poolChunk) {
        if (poolChunk.freeBytes <= this.freeMinThreshold) {
            this.nextList.add(poolChunk);
            return;
        }
        this.add0(poolChunk);
    }

    void add0(PoolChunk<T> poolChunk) {
        poolChunk.parent = this;
        if (this.head == null) {
            this.head = poolChunk;
            poolChunk.prev = null;
            poolChunk.next = null;
        } else {
            poolChunk.prev = null;
            poolChunk.next = this.head;
            this.head.prev = poolChunk;
            this.head = poolChunk;
        }
    }

    private void remove(PoolChunk<T> poolChunk) {
        if (poolChunk == this.head) {
            this.head = poolChunk.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            PoolChunk poolChunk2;
            poolChunk.prev.next = poolChunk2 = poolChunk.next;
            if (poolChunk2 != null) {
                poolChunk2.prev = poolChunk.prev;
            }
        }
    }

    private static int minUsage0(int n2) {
        return Math.max(1, n2);
    }

    @Override
    public Iterator<PoolChunkMetric> iterator() {
        this.arena.lock();
        try {
            if (this.head == null) {
                Iterator<PoolChunkMetric> iterator = EMPTY_METRICS;
                return iterator;
            }
            ArrayList<PoolChunk<T>> arrayList = new ArrayList<PoolChunk<T>>();
            Object object = this.head;
            do {
                arrayList.add((PoolChunk<T>)object);
            } while ((object = ((PoolChunk)object).next) != null);
            object = arrayList.iterator();
            return object;
        }
        finally {
            this.arena.unlock();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.arena.lock();
        try {
            if (this.head == null) {
                String string = "none";
                return string;
            }
            PoolChunk<T> poolChunk = this.head;
            while (true) {
                stringBuilder.append(poolChunk);
                poolChunk = poolChunk.next;
                if (poolChunk == null) {
                    break;
                }
                stringBuilder.append(StringUtil.NEWLINE);
            }
        }
        finally {
            this.arena.unlock();
        }
        return stringBuilder.toString();
    }

    void destroy(PoolArena<T> poolArena) {
        PoolChunk<T> poolChunk = this.head;
        while (poolChunk != null) {
            poolArena.destroyChunk(poolChunk);
            poolChunk = poolChunk.next;
        }
        this.head = null;
    }
}

