/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.SerializedString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyMetadata;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanPropertyWriter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.Annotations;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;

@JacksonStdImpl
public class BeanPropertyWriter
extends PropertyWriter
implements Serializable {
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final SerializedString _name;
    protected final PropertyName _wrapperName;
    protected final JavaType _declaredType;
    protected final JavaType _cfgSerializationType;
    protected JavaType _nonTrivialBaseType;
    protected final transient Annotations _contextAnnotations;
    protected final AnnotatedMember _member;
    protected transient Method _accessorMethod;
    protected transient Field _field;
    protected JsonSerializer<Object> _serializer;
    protected JsonSerializer<Object> _nullSerializer;
    protected TypeSerializer _typeSerializer;
    protected transient PropertySerializerMap _dynamicSerializers;
    protected final boolean _suppressNulls;
    protected final Object _suppressableValue;
    protected final Class<?>[] _includeInViews;
    protected transient HashMap<Object, Object> _internalSettings;

    public BeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, AnnotatedMember annotatedMember, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, boolean bl2, Object object, Class<?>[] classArray) {
        super(beanPropertyDefinition);
        this._member = annotatedMember;
        this._contextAnnotations = annotations;
        this._name = new SerializedString(beanPropertyDefinition.getName());
        this._wrapperName = beanPropertyDefinition.getWrapperName();
        this._declaredType = javaType;
        this._serializer = jsonSerializer;
        this._dynamicSerializers = jsonSerializer == null ? PropertySerializerMap.emptyForProperties() : null;
        this._typeSerializer = typeSerializer;
        this._cfgSerializationType = javaType2;
        if (annotatedMember instanceof AnnotatedField) {
            this._accessorMethod = null;
            this._field = (Field)annotatedMember.getMember();
        } else if (annotatedMember instanceof AnnotatedMethod) {
            this._accessorMethod = (Method)annotatedMember.getMember();
            this._field = null;
        } else {
            this._accessorMethod = null;
            this._field = null;
        }
        this._suppressNulls = bl2;
        this._suppressableValue = object;
        this._nullSerializer = null;
        this._includeInViews = classArray;
    }

    protected BeanPropertyWriter() {
        super(PropertyMetadata.STD_REQUIRED_OR_OPTIONAL);
        this._member = null;
        this._contextAnnotations = null;
        this._name = null;
        this._wrapperName = null;
        this._includeInViews = null;
        this._declaredType = null;
        this._serializer = null;
        this._dynamicSerializers = null;
        this._typeSerializer = null;
        this._cfgSerializationType = null;
        this._accessorMethod = null;
        this._field = null;
        this._suppressNulls = false;
        this._suppressableValue = null;
        this._nullSerializer = null;
    }

    protected BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter) {
        this(beanPropertyWriter, beanPropertyWriter._name);
    }

    protected BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, PropertyName propertyName) {
        super(beanPropertyWriter);
        this._name = new SerializedString(propertyName.getSimpleName());
        this._wrapperName = beanPropertyWriter._wrapperName;
        this._contextAnnotations = beanPropertyWriter._contextAnnotations;
        this._declaredType = beanPropertyWriter._declaredType;
        this._member = beanPropertyWriter._member;
        this._accessorMethod = beanPropertyWriter._accessorMethod;
        this._field = beanPropertyWriter._field;
        this._serializer = beanPropertyWriter._serializer;
        this._nullSerializer = beanPropertyWriter._nullSerializer;
        if (beanPropertyWriter._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(beanPropertyWriter._internalSettings);
        }
        this._cfgSerializationType = beanPropertyWriter._cfgSerializationType;
        this._dynamicSerializers = beanPropertyWriter._dynamicSerializers;
        this._suppressNulls = beanPropertyWriter._suppressNulls;
        this._suppressableValue = beanPropertyWriter._suppressableValue;
        this._includeInViews = beanPropertyWriter._includeInViews;
        this._typeSerializer = beanPropertyWriter._typeSerializer;
        this._nonTrivialBaseType = beanPropertyWriter._nonTrivialBaseType;
    }

    protected BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, SerializedString serializedString) {
        super(beanPropertyWriter);
        this._name = serializedString;
        this._wrapperName = beanPropertyWriter._wrapperName;
        this._member = beanPropertyWriter._member;
        this._contextAnnotations = beanPropertyWriter._contextAnnotations;
        this._declaredType = beanPropertyWriter._declaredType;
        this._accessorMethod = beanPropertyWriter._accessorMethod;
        this._field = beanPropertyWriter._field;
        this._serializer = beanPropertyWriter._serializer;
        this._nullSerializer = beanPropertyWriter._nullSerializer;
        if (beanPropertyWriter._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(beanPropertyWriter._internalSettings);
        }
        this._cfgSerializationType = beanPropertyWriter._cfgSerializationType;
        this._dynamicSerializers = beanPropertyWriter._dynamicSerializers;
        this._suppressNulls = beanPropertyWriter._suppressNulls;
        this._suppressableValue = beanPropertyWriter._suppressableValue;
        this._includeInViews = beanPropertyWriter._includeInViews;
        this._typeSerializer = beanPropertyWriter._typeSerializer;
        this._nonTrivialBaseType = beanPropertyWriter._nonTrivialBaseType;
    }

    public BeanPropertyWriter rename(NameTransformer nameTransformer) {
        String string = nameTransformer.transform(this._name.getValue());
        if (string.equals(this._name.toString())) {
            return this;
        }
        return this._new(PropertyName.construct(string));
    }

    protected BeanPropertyWriter _new(PropertyName propertyName) {
        return new BeanPropertyWriter(this, propertyName);
    }

    public void assignTypeSerializer(TypeSerializer typeSerializer) {
        this._typeSerializer = typeSerializer;
    }

    public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
        if (this._serializer != null && this._serializer != jsonSerializer) {
            throw new IllegalStateException(String.format("Cannot override _serializer: had a %s, trying to set to %s", ClassUtil.classNameOf(this._serializer), ClassUtil.classNameOf(jsonSerializer)));
        }
        this._serializer = jsonSerializer;
    }

    public void assignNullSerializer(JsonSerializer<Object> jsonSerializer) {
        if (this._nullSerializer != null && this._nullSerializer != jsonSerializer) {
            throw new IllegalStateException(String.format("Cannot override _nullSerializer: had a %s, trying to set to %s", ClassUtil.classNameOf(this._nullSerializer), ClassUtil.classNameOf(jsonSerializer)));
        }
        this._nullSerializer = jsonSerializer;
    }

    public BeanPropertyWriter unwrappingWriter(NameTransformer nameTransformer) {
        return new UnwrappingBeanPropertyWriter(this, nameTransformer);
    }

    public void setNonTrivialBaseType(JavaType javaType) {
        this._nonTrivialBaseType = javaType;
    }

    public void fixAccess(SerializationConfig serializationConfig) {
        this._member.fixAccess(serializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public String getName() {
        return this._name.getValue();
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this._name.getValue());
    }

    @Override
    public JavaType getType() {
        return this._declaredType;
    }

    @Override
    public AnnotatedMember getMember() {
        return this._member;
    }

    protected void _depositSchemaProperty(ObjectNode objectNode, JsonNode jsonNode) {
        objectNode.set(this.getName(), jsonNode);
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    public boolean hasNullSerializer() {
        return this._nullSerializer != null;
    }

    public TypeSerializer getTypeSerializer() {
        return this._typeSerializer;
    }

    public boolean willSuppressNulls() {
        return this._suppressNulls;
    }

    public boolean wouldConflictWithName(PropertyName propertyName) {
        if (this._wrapperName != null) {
            return this._wrapperName.equals(propertyName);
        }
        return propertyName.hasSimpleName(this._name.getValue()) && !propertyName.hasNamespace();
    }

    public JsonSerializer<Object> getSerializer() {
        return this._serializer;
    }

    public JavaType getSerializationType() {
        return this._cfgSerializationType;
    }

    public Class<?>[] getViews() {
        return this._includeInViews;
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2;
        Object object3 = object2 = this._accessorMethod == null ? this._field.get(object) : this._accessorMethod.invoke(object, (Object[])null);
        if (object2 == null) {
            if (this._suppressableValue != null && serializerProvider.includeFilterSuppressNulls(this._suppressableValue)) {
                return;
            }
            if (this._nullSerializer != null) {
                jsonGenerator.writeFieldName(this._name);
                this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? jsonSerializer.isEmpty(serializerProvider, object2) : this._suppressableValue.equals(object2))) {
            return;
        }
        if (object2 == object && this._handleSelfReference(object, jsonGenerator, serializerProvider, jsonSerializer)) {
            return;
        }
        jsonGenerator.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        if (!jsonGenerator.canOmitFields()) {
            jsonGenerator.writeOmittedField(this._name.getValue());
        }
    }

    public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2;
        Object object3 = object2 = this._accessorMethod == null ? this._field.get(object) : this._accessorMethod.invoke(object, (Object[])null);
        if (object2 == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            } else {
                jsonGenerator.writeNull();
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (jsonSerializer.isEmpty(serializerProvider, object2)) {
                    this.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                    return;
                }
            } else if (this._suppressableValue.equals(object2)) {
                this.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                return;
            }
        }
        if (object2 == object && this._handleSelfReference(object, jsonGenerator, serializerProvider, jsonSerializer)) {
            return;
        }
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    public void serializeAsPlaceholder(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        if (this._nullSerializer != null) {
            this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
        } else {
            jsonGenerator.writeNull();
        }
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
        if (jsonObjectFormatVisitor != null) {
            if (this.isRequired()) {
                jsonObjectFormatVisitor.property(this);
            } else {
                jsonObjectFormatVisitor.optionalProperty(this);
            }
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode objectNode, SerializerProvider serializerProvider) throws JsonMappingException {
        JavaType javaType = this.getSerializationType();
        Type type = javaType == null ? this.getType() : javaType.getRawClass();
        JsonSerializer<Object> jsonSerializer = this.getSerializer();
        if (jsonSerializer == null) {
            jsonSerializer = serializerProvider.findValueSerializer(this.getType(), (BeanProperty)this);
        }
        boolean bl2 = !this.isRequired();
        JsonNode jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, type, bl2) : JsonSchema.getDefaultSchemaNode();
        this._depositSchemaProperty(objectNode, jsonNode);
    }

    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult;
        if (this._nonTrivialBaseType != null) {
            JavaType javaType = serializerProvider.constructSpecializedType(this._nonTrivialBaseType, clazz);
            serializerAndMapResult = propertySerializerMap.findAndAddPrimarySerializer(javaType, serializerProvider, (BeanProperty)this);
        } else {
            serializerAndMapResult = propertySerializerMap.findAndAddPrimarySerializer(clazz, serializerProvider, (BeanProperty)this);
        }
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    public final Object get(Object object) throws Exception {
        return this._accessorMethod == null ? this._field.get(object) : this._accessorMethod.invoke(object, (Object[])null);
    }

    protected boolean _handleSelfReference(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<?> jsonSerializer) throws IOException {
        if (!jsonSerializer.usesObjectId()) {
            if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_SELF_REFERENCES)) {
                if (jsonSerializer instanceof BeanSerializerBase) {
                    serializerProvider.reportBadDefinition(this.getType(), "Direct self-reference leading to cycle");
                }
            } else if (serializerProvider.isEnabled(SerializationFeature.WRITE_SELF_REFERENCES_AS_NULL)) {
                if (this._nullSerializer != null) {
                    if (!jsonGenerator.getOutputContext().inArray()) {
                        jsonGenerator.writeFieldName(this._name);
                    }
                    this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("property '").append(this.getName()).append("' (");
        if (this._accessorMethod != null) {
            stringBuilder.append("via method ").append(this._accessorMethod.getDeclaringClass().getName()).append("#").append(this._accessorMethod.getName());
        } else if (this._field != null) {
            stringBuilder.append("field \"").append(this._field.getDeclaringClass().getName()).append("#").append(this._field.getName());
        } else {
            stringBuilder.append("virtual");
        }
        if (this._serializer == null) {
            stringBuilder.append(", no static serializer");
        } else {
            stringBuilder.append(", static serializer of type " + this._serializer.getClass().getName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

