package com.gradle.develocity.agent.gradle.test;

import com.gradle.obfuscation.Keep;
import org.gradle.api.Action;
import org.gradle.api.tasks.Nested;

/**
 * The DSL extension for configuring Develocity testing features, with the name {@code develocity}.
 *
 * <pre>{@code
 * tasks.test {
 *   develocity {
 *     // Develocity configuration
 *     testDistribution {
 *       enabled.set(true)
 *     }
 *     predictiveTestSelection {
 *       enabled.set(true)
 *     }
 *     testRetry {
 *       maxRetries.set(2)
 *     }
 *   }
 * }
 * }</pre>
 *
 * @since 3.17
 */
@Keep
public interface DevelocityTestConfiguration {

    /**
     * The Predictive Test Selection configuration.
     *
     * @return the Predictive Test Selection configuration
     */
    @Nested
    PredictiveTestSelectionConfiguration getPredictiveTestSelection();

    /**
     * Configure Predictive Test Selection.
     *
     * @param action the configuration action
     */
    void predictiveTestSelection(Action<? super PredictiveTestSelectionConfiguration> action);

    /**
     * The Test Distribution configuration.
     *
     * @return the Test Distribution configuration
     */
    @Nested
    TestDistributionConfiguration getTestDistribution();

    /**
     * Configure Test Distribution.
     *
     * @param action the configuration action
     */
    void testDistribution(Action<? super TestDistributionConfiguration> action);

    /**
     * The test retry configuration.
     *
     * @return the test retry configuration
     */
    @Nested
    TestRetryConfiguration getTestRetry();

    /**
     * Configure test retries.
     *
     * @param action the configuration action
     */
    void testRetry(Action<? super TestRetryConfiguration> action);

}
