package com.gradle.develocity.agent.gradle.scan;

import com.gradle.obfuscation.Keep;
import org.gradle.api.specs.Spec;

/**
 * Allows configuring when a build scan should be published at the end of the build.
 *
 * @since 3.17
 */
@Keep
public interface BuildScanPublishingConfiguration {

    /**
     * Specify a condition for when a build scan should be published at the end of the build.
     * <p>
     * You may add multiple such predicates. A build scan will be published if any of the predicates return true.
     */
    void onlyIf(Spec<? super PublishingContext> predicate);

    /**
     * The context for evaluating conditions that determine whether a build scan should be published at the end of the build.
     *
     * @see #onlyIf(Spec)
     * @since 3.17
     */
    @Keep
    interface PublishingContext {

        BuildResult getBuildResult();

        boolean isAuthenticated();

    }

}
