/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.windows.perfmon;

import com.gradle.scan.plugin.internal.dep.oshi.util.GlobalConfig;
import com.gradle.scan.plugin.internal.dep.oshi.util.Util;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerfmonDisabled {
    private static final Logger LOG = LoggerFactory.getLogger(PerfmonDisabled.class);
    public static final boolean PERF_OS_DISABLED = PerfmonDisabled.isDisabled("com.gradle.scan.plugin.internal.dep.oshi.os.windows.perfos.disabled", "PerfOS");
    public static final boolean PERF_PROC_DISABLED = PerfmonDisabled.isDisabled("com.gradle.scan.plugin.internal.dep.oshi.os.windows.perfproc.disabled", "PerfProc");
    public static final boolean PERF_DISK_DISABLED = PerfmonDisabled.isDisabled("com.gradle.scan.plugin.internal.dep.oshi.os.windows.perfdisk.disabled", "PerfDisk");

    private PerfmonDisabled() {
        throw new AssertionError();
    }

    private static boolean isDisabled(String string, String string2) {
        String string3 = GlobalConfig.get(string);
        if (Util.isBlank(string3)) {
            String string4;
            String string5 = String.format(Locale.ROOT, "SYSTEM\\CurrentControlSet\\Services\\%s\\Performance", string2);
            if (Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, string5, string4 = "Disable Performance Counters")) {
                Object object = Advapi32Util.registryGetValue(WinReg.HKEY_LOCAL_MACHINE, string5, string4);
                if (object instanceof Integer) {
                    if ((Integer)object > 0) {
                        LOG.warn("{} counters are disabled and won't return data: {}\\\\{}\\\\{} > 0.", new Object[]{string2, "HKEY_LOCAL_MACHINE", string5, string4});
                        return true;
                    }
                } else {
                    LOG.warn("Invalid registry value type detected for {} counters. Should be REG_DWORD. Ignoring: {}\\\\{}\\\\{}.", new Object[]{string2, "HKEY_LOCAL_MACHINE", string5, string4});
                }
            }
            return false;
        }
        return Boolean.parseBoolean(string3);
    }
}

