/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.module.paramnames;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.Annotated;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.module.paramnames.ParameterExtractor;
import java.lang.reflect.Executable;
import java.lang.reflect.MalformedParametersException;
import java.lang.reflect.Parameter;

public class ParameterNamesAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final JsonCreator.Mode creatorBinding;
    private final ParameterExtractor parameterExtractor;

    ParameterNamesAnnotationIntrospector(JsonCreator.Mode mode, ParameterExtractor parameterExtractor) {
        this.creatorBinding = mode;
        this.parameterExtractor = parameterExtractor;
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember annotatedMember) {
        if (annotatedMember instanceof AnnotatedParameter) {
            return this.findParameterName((AnnotatedParameter)annotatedMember);
        }
        return null;
    }

    private String findParameterName(AnnotatedParameter annotatedParameter) {
        Parameter[] parameterArray;
        try {
            parameterArray = this.getParameters(annotatedParameter.getOwner());
        }
        catch (MalformedParametersException malformedParametersException) {
            return null;
        }
        Parameter parameter = parameterArray[annotatedParameter.getIndex()];
        return parameter.isNamePresent() ? parameter.getName() : null;
    }

    private Parameter[] getParameters(AnnotatedWithParams annotatedWithParams) {
        if (annotatedWithParams instanceof AnnotatedConstructor) {
            return this.parameterExtractor.getParameters((Executable)((AnnotatedConstructor)annotatedWithParams).getAnnotated());
        }
        if (annotatedWithParams instanceof AnnotatedMethod) {
            return this.parameterExtractor.getParameters(((AnnotatedMethod)annotatedWithParams).getAnnotated());
        }
        return null;
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> mapperConfig, Annotated annotated) {
        JsonCreator jsonCreator = this._findAnnotation(annotated, JsonCreator.class);
        if (jsonCreator != null) {
            JsonCreator.Mode mode = jsonCreator.mode();
            if (this.creatorBinding != null && mode == JsonCreator.Mode.DEFAULT) {
                mode = this.creatorBinding;
            }
            return mode;
        }
        return null;
    }
}

