/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.util;

import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.FileUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.Platform;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class UserGroupInfo {
    private static final Supplier<Map<String, String>> USERS_ID_MAP = Memoizer.memoize(UserGroupInfo::getUserMap, TimeUnit.MINUTES.toNanos(5L));
    private static final Supplier<Map<String, String>> GROUPS_ID_MAP = Memoizer.memoize(UserGroupInfo::getGroupMap, TimeUnit.MINUTES.toNanos(5L));
    private static final boolean ELEVATED = 0 == ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("id -u"), -1);

    public static boolean isElevated() {
        return ELEVATED;
    }

    public static String getUser(String string) {
        return USERS_ID_MAP.get().getOrDefault(string, UserGroupInfo.getentPasswd(string));
    }

    public static String getGroupName(String string) {
        return GROUPS_ID_MAP.get().getOrDefault(string, UserGroupInfo.getentGroup(string));
    }

    private static Map<String, String> getUserMap() {
        return UserGroupInfo.parsePasswd(FileUtil.readFile("/etc/passwd"));
    }

    private static String getentPasswd(String string) {
        if (Platform.isAIX()) {
            return "unknown";
        }
        Map<String, String> map = UserGroupInfo.parsePasswd(ExecutingCommand.runNative("getent passwd " + string));
        USERS_ID_MAP.get().putAll(map);
        return map.getOrDefault(string, "unknown");
    }

    private static Map<String, String> parsePasswd(List<String> list) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        for (String string : list) {
            String[] stringArray = string.split(":");
            if (stringArray.length <= 2) continue;
            String string2 = stringArray[0];
            String string3 = stringArray[2];
            concurrentHashMap.putIfAbsent(string3, string2);
        }
        return concurrentHashMap;
    }

    private static Map<String, String> getGroupMap() {
        return UserGroupInfo.parseGroup(FileUtil.readFile("/etc/group"));
    }

    private static String getentGroup(String string) {
        if (Platform.isAIX()) {
            return "unknown";
        }
        Map<String, String> map = UserGroupInfo.parseGroup(ExecutingCommand.runNative("getent group " + string));
        GROUPS_ID_MAP.get().putAll(map);
        return map.getOrDefault(string, "unknown");
    }

    private static Map<String, String> parseGroup(List<String> list) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        for (String string : list) {
            String[] stringArray = string.split(":");
            if (stringArray.length <= 2) continue;
            String string2 = stringArray[0];
            String string3 = stringArray[2];
            concurrentHashMap.putIfAbsent(string3, string2);
        }
        return concurrentHashMap;
    }
}

