/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.openbsd;

import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.OpenBsdLibc;
import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.openbsd.OpenBsdOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.unix.openbsd.OpenBsdSysctlUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenBsdOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdOperatingSystem.class);
    private static final long BOOTTIME = OpenBsdOperatingSystem.querySystemBootTime();
    static final String PS_COMMAND_ARGS = Arrays.stream(PsKeywords.values()).map(Enum::name).map(string -> string.toLowerCase(Locale.ROOT)).collect(Collectors.joining(","));

    @Override
    public String queryManufacturer() {
        return "Unix/BSD";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        int[] nArray = new int[]{1, 1};
        String string = OpenBsdSysctlUtil.sysctl(nArray, "OpenBSD");
        nArray[1] = 2;
        String string2 = OpenBsdSysctlUtil.sysctl(nArray, "");
        nArray[1] = 4;
        String string3 = OpenBsdSysctlUtil.sysctl(nArray, "");
        String string4 = string3.split(":")[0].replace(string, "").replace(string2, "").trim();
        return new Pair<String, OperatingSystem.OSVersionInfo>(string, new OperatingSystem.OSVersionInfo(string2, null, string4));
    }

    @Override
    protected int queryBitness(int n2) {
        if (n2 < 64 && ExecutingCommand.getFirstAnswer("uname -m").indexOf("64") == -1) {
            return n2;
        }
        return 64;
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.getProcessListFromPS(-1);
    }

    private List<OSProcess> getProcessListFromPS(int n2) {
        List<String> list;
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        String string = "ps -awwxo " + PS_COMMAND_ARGS;
        if (n2 >= 0) {
            string = string + " -p " + n2;
        }
        if ((list = ExecutingCommand.runNative(string)).isEmpty() || list.size() < 2) {
            return arrayList;
        }
        list.remove(0);
        for (String string2 : list) {
            Map<PsKeywords, String> map = ParseUtil.stringToEnumMap(PsKeywords.class, string2.trim(), ' ');
            if (!map.containsKey((Object)PsKeywords.ARGS)) continue;
            arrayList.add(new OpenBsdOSProcess(n2 < 0 ? ParseUtil.parseIntOrDefault(map.get((Object)PsKeywords.PID), 0) : n2, map, this));
        }
        return arrayList;
    }

    @Override
    public int getProcessId() {
        return OpenBsdLibc.INSTANCE.getpid();
    }

    private static long querySystemBootTime() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L);
    }

    static enum PsKeywords {
        STATE,
        PID,
        PPID,
        USER,
        UID,
        GROUP,
        GID,
        PRI,
        VSZ,
        RSS,
        ETIME,
        CPUTIME,
        COMM,
        MAJFLT,
        MINFLT,
        NVCSW,
        NIVCSW,
        ARGS;

    }
}

