/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.OptBoolean;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.TimeZone;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonFormat {
    public static final String DEFAULT_LOCALE = "##default";
    public static final String DEFAULT_TIMEZONE = "##default";

    public String pattern() default "";

    public Shape shape() default Shape.ANY;

    public String locale() default "##default";

    public String timezone() default "##default";

    public OptBoolean lenient() default OptBoolean.DEFAULT;

    public Feature[] with() default {};

    public Feature[] without() default {};

    public static class Value
    implements JacksonAnnotationValue<JsonFormat>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Value EMPTY = new Value();
        private final String _pattern;
        private final Shape _shape;
        private final Locale _locale;
        private final String _timezoneStr;
        private final Boolean _lenient;
        private final Features _features;
        private transient TimeZone _timezone;

        public Value() {
            this("", Shape.ANY, "", "", Features.empty(), null);
        }

        public Value(JsonFormat jsonFormat) {
            this(jsonFormat.pattern(), jsonFormat.shape(), jsonFormat.locale(), jsonFormat.timezone(), Features.construct(jsonFormat), jsonFormat.lenient().asBoolean());
        }

        public Value(String string, Shape shape, String string2, String string3, Features features, Boolean bl2) {
            this(string, shape, string2 == null || string2.length() == 0 || "##default".equals(string2) ? null : new Locale(string2), string3 == null || string3.length() == 0 || "##default".equals(string3) ? null : string3, null, features, bl2);
        }

        public Value(String string, Shape shape, Locale locale, TimeZone timeZone, Features features, Boolean bl2) {
            this._pattern = string == null ? "" : string;
            this._shape = shape == null ? Shape.ANY : shape;
            this._locale = locale;
            this._timezone = timeZone;
            this._timezoneStr = null;
            this._features = features == null ? Features.empty() : features;
            this._lenient = bl2;
        }

        public Value(String string, Shape shape, Locale locale, String string2, TimeZone timeZone, Features features, Boolean bl2) {
            this._pattern = string == null ? "" : string;
            this._shape = shape == null ? Shape.ANY : shape;
            this._locale = locale;
            this._timezone = timeZone;
            this._timezoneStr = string2;
            this._features = features == null ? Features.empty() : features;
            this._lenient = bl2;
        }

        @Deprecated
        public Value(String string, Shape shape, Locale locale, String string2, TimeZone timeZone, Features features) {
            this(string, shape, locale, string2, timeZone, features, null);
        }

        @Deprecated
        public Value(String string, Shape shape, String string2, String string3, Features features) {
            this(string, shape, string2, string3, features, null);
        }

        @Deprecated
        public Value(String string, Shape shape, Locale locale, TimeZone timeZone, Features features) {
            this(string, shape, locale, timeZone, features, null);
        }

        public static final Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            return value == null ? value2 : value.withOverrides(value2);
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                value = value == null ? value2 : value.withOverrides(value2);
            }
            return value;
        }

        public static final Value from(JsonFormat jsonFormat) {
            return jsonFormat == null ? EMPTY : new Value(jsonFormat);
        }

        public final Value withOverrides(Value value) {
            TimeZone timeZone;
            String string;
            Features features;
            Locale locale;
            Shape shape;
            if (value == null || value == EMPTY || value == this) {
                return this;
            }
            if (this == EMPTY) {
                return value;
            }
            String string2 = value._pattern;
            if (string2 == null || string2.isEmpty()) {
                string2 = this._pattern;
            }
            if ((shape = value._shape) == Shape.ANY) {
                shape = this._shape;
            }
            if ((locale = value._locale) == null) {
                locale = this._locale;
            }
            features = (features = this._features) == null ? value._features : features.withOverrides(value._features);
            Boolean bl2 = value._lenient;
            if (bl2 == null) {
                bl2 = this._lenient;
            }
            if ((string = value._timezoneStr) == null || string.isEmpty()) {
                string = this._timezoneStr;
                timeZone = this._timezone;
            } else {
                timeZone = value._timezone;
            }
            return new Value(string2, shape, locale, string, timeZone, features, bl2);
        }

        public static Value forPattern(String string) {
            return new Value(string, null, null, null, null, Features.empty(), null);
        }

        public static Value forShape(Shape shape) {
            return new Value("", shape, null, null, null, Features.empty(), null);
        }

        public static Value forLeniency(boolean bl2) {
            return new Value("", null, null, null, null, Features.empty(), bl2);
        }

        public Value withPattern(String string) {
            return new Value(string, this._shape, this._locale, this._timezoneStr, this._timezone, this._features, this._lenient);
        }

        public Value withShape(Shape shape) {
            if (shape == this._shape) {
                return this;
            }
            return new Value(this._pattern, shape, this._locale, this._timezoneStr, this._timezone, this._features, this._lenient);
        }

        public Value withLocale(Locale locale) {
            return new Value(this._pattern, this._shape, locale, this._timezoneStr, this._timezone, this._features, this._lenient);
        }

        public Value withTimeZone(TimeZone timeZone) {
            return new Value(this._pattern, this._shape, this._locale, null, timeZone, this._features, this._lenient);
        }

        public Value withLenient(Boolean bl2) {
            if (bl2 == this._lenient) {
                return this;
            }
            return new Value(this._pattern, this._shape, this._locale, this._timezoneStr, this._timezone, this._features, bl2);
        }

        public Value withFeature(Feature feature) {
            Features features = this._features.with(feature);
            return features == this._features ? this : new Value(this._pattern, this._shape, this._locale, this._timezoneStr, this._timezone, features, this._lenient);
        }

        public Value withoutFeature(Feature feature) {
            Features features = this._features.without(feature);
            return features == this._features ? this : new Value(this._pattern, this._shape, this._locale, this._timezoneStr, this._timezone, features, this._lenient);
        }

        @Override
        public Class<JsonFormat> valueFor() {
            return JsonFormat.class;
        }

        public String getPattern() {
            return this._pattern;
        }

        public Shape getShape() {
            return this._shape;
        }

        public Locale getLocale() {
            return this._locale;
        }

        public Boolean getLenient() {
            return this._lenient;
        }

        public boolean isLenient() {
            return Boolean.TRUE.equals(this._lenient);
        }

        public String timeZoneAsString() {
            if (this._timezone != null) {
                return this._timezone.getID();
            }
            return this._timezoneStr;
        }

        public TimeZone getTimeZone() {
            TimeZone timeZone = this._timezone;
            if (timeZone == null) {
                if (this._timezoneStr == null) {
                    return null;
                }
                this._timezone = timeZone = TimeZone.getTimeZone(this._timezoneStr);
            }
            return timeZone;
        }

        public boolean hasShape() {
            return this._shape != Shape.ANY;
        }

        public boolean hasPattern() {
            return this._pattern != null && this._pattern.length() > 0;
        }

        public boolean hasLocale() {
            return this._locale != null;
        }

        public boolean hasTimeZone() {
            return this._timezone != null || this._timezoneStr != null && !this._timezoneStr.isEmpty();
        }

        public boolean hasLenient() {
            return this._lenient != null;
        }

        public Boolean getFeature(Feature feature) {
            return this._features.get(feature);
        }

        public Features getFeatures() {
            return this._features;
        }

        public String toString() {
            return String.format("JsonFormat.Value(pattern=%s,shape=%s,lenient=%s,locale=%s,timezone=%s,features=%s)", new Object[]{this._pattern, this._shape, this._lenient, this._locale, this._timezoneStr, this._features});
        }

        public int hashCode() {
            int n2;
            int n3 = n2 = this._timezoneStr == null ? 1 : this._timezoneStr.hashCode();
            if (this._pattern != null) {
                n2 ^= this._pattern.hashCode();
            }
            n2 += this._shape.hashCode();
            if (this._lenient != null) {
                n2 ^= this._lenient.hashCode();
            }
            if (this._locale != null) {
                n2 += this._locale.hashCode();
            }
            return n2 ^= this._features.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Value value = (Value)object;
            if (this._shape != value._shape || !this._features.equals(value._features)) {
                return false;
            }
            return Value._equal(this._lenient, value._lenient) && Value._equal(this._timezoneStr, value._timezoneStr) && Value._equal(this._pattern, value._pattern) && Value._equal(this._timezone, value._timezone) && Value._equal(this._locale, value._locale);
        }

        private static <T> boolean _equal(T t2, T t3) {
            if (t2 == null) {
                return t3 == null;
            }
            if (t3 == null) {
                return false;
            }
            return t2.equals(t3);
        }
    }

    public static class Features {
        private final int _enabled;
        private final int _disabled;
        private static final Features EMPTY = new Features(0, 0);

        private Features(int n2, int n3) {
            this._enabled = n2;
            this._disabled = n3;
        }

        public static Features empty() {
            return EMPTY;
        }

        public static Features construct(JsonFormat jsonFormat) {
            return Features.construct(jsonFormat.with(), jsonFormat.without());
        }

        public static Features construct(Feature[] featureArray, Feature[] featureArray2) {
            int n2 = 0;
            for (Feature feature : featureArray) {
                n2 |= 1 << feature.ordinal();
            }
            int n3 = 0;
            for (Feature feature : featureArray2) {
                n3 |= 1 << feature.ordinal();
            }
            return new Features(n2, n3);
        }

        public Features withOverrides(Features features) {
            if (features == null) {
                return this;
            }
            int n2 = features._disabled;
            int n3 = features._enabled;
            if (n2 == 0 && n3 == 0) {
                return this;
            }
            if (this._enabled == 0 && this._disabled == 0) {
                return features;
            }
            int n4 = this._enabled & ~n2 | n3;
            int n5 = this._disabled & ~n3 | n2;
            if (n4 == this._enabled && n5 == this._disabled) {
                return this;
            }
            return new Features(n4, n5);
        }

        public Features with(Feature ... featureArray) {
            int n2 = this._enabled;
            for (Feature feature : featureArray) {
                n2 |= 1 << feature.ordinal();
            }
            return n2 == this._enabled ? this : new Features(n2, this._disabled);
        }

        public Features without(Feature ... featureArray) {
            int n2 = this._disabled;
            for (Feature feature : featureArray) {
                n2 |= 1 << feature.ordinal();
            }
            return n2 == this._disabled ? this : new Features(this._enabled, n2);
        }

        public Boolean get(Feature feature) {
            int n2 = 1 << feature.ordinal();
            if ((this._disabled & n2) != 0) {
                return Boolean.FALSE;
            }
            if ((this._enabled & n2) != 0) {
                return Boolean.TRUE;
            }
            return null;
        }

        public String toString() {
            if (this == EMPTY) {
                return "EMPTY";
            }
            return String.format("(enabled=0x%x,disabled=0x%x)", this._enabled, this._disabled);
        }

        public int hashCode() {
            return this._disabled + this._enabled;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Features features = (Features)object;
            return features._enabled == this._enabled && features._disabled == this._disabled;
        }
    }

    public static enum Feature {
        ACCEPT_SINGLE_VALUE_AS_ARRAY,
        ACCEPT_CASE_INSENSITIVE_PROPERTIES,
        READ_UNKNOWN_ENUM_VALUES_AS_NULL,
        READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE,
        READ_DATE_TIMESTAMPS_AS_NANOSECONDS,
        ACCEPT_CASE_INSENSITIVE_VALUES,
        WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS,
        WRITE_DATES_WITH_ZONE_ID,
        WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED,
        WRITE_SORTED_MAP_ENTRIES,
        ADJUST_DATES_TO_CONTEXT_TIME_ZONE;

    }

    public static enum Shape {
        ANY,
        NATURAL,
        SCALAR,
        ARRAY,
        OBJECT,
        NUMBER,
        NUMBER_FLOAT,
        NUMBER_INT,
        STRING,
        BOOLEAN,
        BINARY;


        public boolean isNumeric() {
            return this == NUMBER || this == NUMBER_INT || this == NUMBER_FLOAT;
        }

        public boolean isStructured() {
            return this == OBJECT || this == ARRAY;
        }
    }
}

