/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.resolver;

import com.gradle.scan.plugin.internal.dep.io.netty.resolver.AddressResolver;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.TypeParameterMatcher;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;

public abstract class AbstractAddressResolver<T extends SocketAddress>
implements AddressResolver<T> {
    private final EventExecutor executor;
    private final TypeParameterMatcher matcher;

    protected AbstractAddressResolver(EventExecutor eventExecutor, Class<? extends T> clazz) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isSupported(SocketAddress socketAddress) {
        return this.matcher.match(socketAddress);
    }

    @Override
    public final boolean isResolved(SocketAddress socketAddress) {
        if (!this.isSupported(socketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        SocketAddress socketAddress2 = socketAddress;
        return this.doIsResolved(socketAddress2);
    }

    protected abstract boolean doIsResolved(T var1);

    @Override
    public final Future<T> resolve(SocketAddress socketAddress) {
        if (!this.isSupported(ObjectUtil.checkNotNull(socketAddress, "address"))) {
            return this.executor().newFailedFuture(new UnsupportedAddressTypeException());
        }
        if (this.isResolved(socketAddress)) {
            SocketAddress socketAddress2 = socketAddress;
            return this.executor.newSucceededFuture(socketAddress2);
        }
        try {
            SocketAddress socketAddress3 = socketAddress;
            Promise promise = this.executor().newPromise();
            this.doResolve(socketAddress3, promise);
            return promise;
        }
        catch (Exception exception) {
            return this.executor().newFailedFuture(exception);
        }
    }

    protected abstract void doResolve(T var1, Promise<T> var2) throws Exception;

    @Override
    public void close() {
    }
}

