/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi;

import com.gradle.scan.plugin.internal.dep.oshi.PlatformEnum;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.HardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.linux.LinuxHardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac.MacHardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.aix.AixHardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.freebsd.FreeBsdHardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.openbsd.OpenBsdHardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.solaris.SolarisHardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.windows.WindowsHardwareAbstractionLayer;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.linux.LinuxOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.mac.MacOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.aix.AixOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.freebsd.FreeBsdOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.openbsd.OpenBsdOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.solaris.SolarisOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.windows.WindowsOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.sun.jna.Platform;
import java.util.function.Supplier;

public class SystemInfo {
    private static final PlatformEnum CURRENT_PLATFORM = PlatformEnum.getValue(Platform.getOSType());
    private final Supplier<OperatingSystem> os = Memoizer.memoize(SystemInfo::createOperatingSystem);
    private final Supplier<HardwareAbstractionLayer> hardware = Memoizer.memoize(SystemInfo::createHardware);

    public static PlatformEnum getCurrentPlatform() {
        return CURRENT_PLATFORM;
    }

    public OperatingSystem getOperatingSystem() {
        return this.os.get();
    }

    private static OperatingSystem createOperatingSystem() {
        switch (CURRENT_PLATFORM) {
            case WINDOWS: {
                return new WindowsOperatingSystem();
            }
            case LINUX: 
            case ANDROID: {
                return new LinuxOperatingSystem();
            }
            case MACOS: {
                return new MacOperatingSystem();
            }
            case SOLARIS: {
                return new SolarisOperatingSystem();
            }
            case FREEBSD: {
                return new FreeBsdOperatingSystem();
            }
            case AIX: {
                return new AixOperatingSystem();
            }
            case OPENBSD: {
                return new OpenBsdOperatingSystem();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + CURRENT_PLATFORM.getName());
    }

    public HardwareAbstractionLayer getHardware() {
        return this.hardware.get();
    }

    private static HardwareAbstractionLayer createHardware() {
        switch (CURRENT_PLATFORM) {
            case WINDOWS: {
                return new WindowsHardwareAbstractionLayer();
            }
            case LINUX: 
            case ANDROID: {
                return new LinuxHardwareAbstractionLayer();
            }
            case MACOS: {
                return new MacHardwareAbstractionLayer();
            }
            case SOLARIS: {
                return new SolarisHardwareAbstractionLayer();
            }
            case FREEBSD: {
                return new FreeBsdHardwareAbstractionLayer();
            }
            case AIX: {
                return new AixHardwareAbstractionLayer();
            }
            case OPENBSD: {
                return new OpenBsdHardwareAbstractionLayer();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + CURRENT_PLATFORM.getName());
    }
}

