/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.ByteToMessageDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.Brotli;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.DecompressionException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.util.List;

public final class BrotliDecoder
extends ByteToMessageDecoder {
    private final int inputBufferSize;
    private DecoderJNI.Wrapper decoder;
    private boolean destroyed;

    public BrotliDecoder() {
        this(8192);
    }

    public BrotliDecoder(int n2) {
        this.inputBufferSize = ObjectUtil.checkPositive(n2, "inputBufferSize");
    }

    private ByteBuf pull(ByteBufAllocator byteBufAllocator) {
        ByteBuffer byteBuffer = this.decoder.pull();
        ByteBuf byteBuf = byteBufAllocator.buffer(byteBuffer.remaining());
        byteBuf.writeBytes(byteBuffer);
        return byteBuf;
    }

    private State decompress(ByteBuf byteBuf, List<Object> list, ByteBufAllocator byteBufAllocator) {
        block6: while (true) {
            switch (this.decoder.getStatus()) {
                case DONE: {
                    return State.DONE;
                }
                case OK: {
                    this.decoder.push(0);
                    continue block6;
                }
                case NEEDS_MORE_INPUT: {
                    if (this.decoder.hasOutput()) {
                        list.add(this.pull(byteBufAllocator));
                    }
                    if (!byteBuf.isReadable()) {
                        return State.NEEDS_MORE_INPUT;
                    }
                    ByteBuffer byteBuffer = this.decoder.getInputBuffer();
                    byteBuffer.clear();
                    int n2 = BrotliDecoder.readBytes(byteBuf, byteBuffer);
                    this.decoder.push(n2);
                    continue block6;
                }
                case NEEDS_MORE_OUTPUT: {
                    list.add(this.pull(byteBufAllocator));
                    continue block6;
                }
            }
            break;
        }
        return State.ERROR;
    }

    private static int readBytes(ByteBuf byteBuf, ByteBuffer byteBuffer) {
        int n2 = Math.min(byteBuf.readableBytes(), byteBuffer.remaining());
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(n2);
        byteBuf.readBytes(byteBuffer2);
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.decoder = new DecoderJNI.Wrapper(this.inputBufferSize);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (this.destroyed) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        if (!byteBuf.isReadable()) {
            return;
        }
        try {
            State state = this.decompress(byteBuf, list, channelHandlerContext.alloc());
            if (state == State.DONE) {
                this.destroy();
            } else if (state == State.ERROR) {
                throw new DecompressionException("Brotli stream corrupted");
            }
        }
        catch (Exception exception) {
            this.destroy();
            throw exception;
        }
    }

    private void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.decoder.destroy();
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            this.destroy();
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            this.destroy();
        }
        finally {
            super.channelInactive(channelHandlerContext);
        }
    }

    static {
        try {
            Brotli.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }

    private static enum State {
        DONE,
        NEEDS_MORE_INPUT,
        ERROR;

    }
}

