/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Hashing;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Iterators;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.RegularImmutableAsList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;

final class RegularImmutableSet<E>
extends ImmutableSet.CachingAsList<E> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(EMPTY_ARRAY, 0, EMPTY_ARRAY, 0);
    private final transient Object[] elements;
    private final transient int hashCode;
    final transient Object[] table;
    private final transient int mask;

    RegularImmutableSet(Object[] objectArray, int n2, Object[] objectArray2, int n3) {
        this.elements = objectArray;
        this.hashCode = n2;
        this.table = objectArray2;
        this.mask = n3;
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        Object[] objectArray = this.table;
        if (object == null || objectArray.length == 0) {
            return false;
        }
        int n2 = Hashing.smearedHash(object);
        Object object2;
        while ((object2 = objectArray[n2 &= this.mask]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1297);
    }

    @Override
    Object[] internalArray() {
        return this.elements;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    int internalArrayEnd() {
        return this.elements.length;
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        System.arraycopy(this.elements, 0, objectArray, n2, this.elements.length);
        return n2 + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.table.length == 0 ? ImmutableList.of() : new RegularImmutableAsList(this, this.elements);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

