/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Collections2;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

public final class Maps {
    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int n2) {
        return new HashMap(Maps.capacity(n2));
    }

    static int capacity(int n2) {
        if (n2 < 3) {
            CollectPreconditions.checkNonnegative(n2, "expectedSize");
            return n2 + 1;
        }
        if (n2 < 0x40000000) {
            return (int)Math.ceil((double)n2 / 0.75);
        }
        return Integer.MAX_VALUE;
    }

    static boolean equalsImpl(Map<?, ?> map, @CheckForNull Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return map.entrySet().equals(map2.entrySet());
        }
        return false;
    }

    static String toStringImpl(Map<?, ?> map) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(map.size()).append('{');
        boolean bl2 = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            bl2 = false;
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.append('}').toString();
    }
}

