/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.base64;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.base64.Base64Dialect;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

public final class Base64 {
    private static byte[] alphabet(Base64Dialect base64Dialect) {
        return ObjectUtil.checkNotNull(base64Dialect, (String)"dialect").alphabet;
    }

    private static byte[] decodabet(Base64Dialect base64Dialect) {
        return ObjectUtil.checkNotNull(base64Dialect, (String)"dialect").decodabet;
    }

    private static boolean breakLines(Base64Dialect base64Dialect) {
        return ObjectUtil.checkNotNull(base64Dialect, (String)"dialect").breakLinesByDefault;
    }

    public static ByteBuf encode(ByteBuf byteBuf) {
        return Base64.encode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl2) {
        return Base64.encode(byteBuf, bl2, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl2, Base64Dialect base64Dialect) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), bl2, base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl2, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n2, n3, bl2, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl2, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ObjectUtil.checkNotNull(base64Dialect, "dialect");
        ByteBuf byteBuf2 = byteBufAllocator.buffer(Base64.encodedBufferSize(n3, bl2)).order(byteBuf.order());
        byte[] byArray = Base64.alphabet(base64Dialect);
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 - 2;
        int n7 = 0;
        while (n4 < n6) {
            Base64.encode3to4(byteBuf, n4 + n2, 3, byteBuf2, n5, byArray);
            if (bl2 && (n7 += 4) == 76) {
                byteBuf2.setByte(n5 + 4, 10);
                ++n5;
                n7 = 0;
            }
            n4 += 3;
            n5 += 4;
        }
        if (n4 < n3) {
            Base64.encode3to4(byteBuf, n4 + n2, n3 - n4, byteBuf2, n5, byArray);
            n5 += 4;
        }
        if (n5 > 1 && byteBuf2.getByte(n5 - 1) == 10) {
            --n5;
        }
        return byteBuf2.slice(0, n5);
    }

    private static void encode3to4(ByteBuf byteBuf, int n2, int n3, ByteBuf byteBuf2, int n4, byte[] byArray) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            int n5;
            switch (n3) {
                case 1: {
                    n5 = Base64.toInt(byteBuf.getByte(n2));
                    break;
                }
                case 2: {
                    n5 = Base64.toIntBE(byteBuf.getShort(n2));
                    break;
                }
                default: {
                    n5 = n3 <= 0 ? 0 : Base64.toIntBE(byteBuf.getMedium(n2));
                }
            }
            Base64.encode3to4BigEndian(n5, n3, byteBuf2, n4, byArray);
        } else {
            int n6;
            switch (n3) {
                case 1: {
                    n6 = Base64.toInt(byteBuf.getByte(n2));
                    break;
                }
                case 2: {
                    n6 = Base64.toIntLE(byteBuf.getShort(n2));
                    break;
                }
                default: {
                    n6 = n3 <= 0 ? 0 : Base64.toIntLE(byteBuf.getMedium(n2));
                }
            }
            Base64.encode3to4LittleEndian(n6, n3, byteBuf2, n4, byArray);
        }
    }

    static int encodedBufferSize(int n2, boolean bl2) {
        long l2 = ((long)n2 << 2) / 3L;
        long l3 = l2 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (bl2) {
            l3 += l2 / 76L;
        }
        return l3 < Integer.MAX_VALUE ? (int)l3 : Integer.MAX_VALUE;
    }

    private static int toInt(byte by2) {
        return (by2 & 0xFF) << 16;
    }

    private static int toIntBE(short s2) {
        return (s2 & 0xFF00) << 8 | (s2 & 0xFF) << 8;
    }

    private static int toIntLE(short s2) {
        return (s2 & 0xFF) << 16 | s2 & 0xFF00;
    }

    private static int toIntBE(int n2) {
        return n2 & 0xFF0000 | n2 & 0xFF00 | n2 & 0xFF;
    }

    private static int toIntLE(int n2) {
        return (n2 & 0xFF) << 16 | n2 & 0xFF00 | (n2 & 0xFF0000) >>> 16;
    }

    private static void encode3to4BigEndian(int n2, int n3, ByteBuf byteBuf, int n4, byte[] byArray) {
        switch (n3) {
            case 3: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] << 24 | byArray[n2 >>> 12 & 0x3F] << 16 | byArray[n2 >>> 6 & 0x3F] << 8 | byArray[n2 & 0x3F]);
                break;
            }
            case 2: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] << 24 | byArray[n2 >>> 12 & 0x3F] << 16 | byArray[n2 >>> 6 & 0x3F] << 8 | 0x3D);
                break;
            }
            case 1: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] << 24 | byArray[n2 >>> 12 & 0x3F] << 16 | 0x3D00 | 0x3D);
                break;
            }
        }
    }

    private static void encode3to4LittleEndian(int n2, int n3, ByteBuf byteBuf, int n4, byte[] byArray) {
        switch (n3) {
            case 3: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] | byArray[n2 >>> 12 & 0x3F] << 8 | byArray[n2 >>> 6 & 0x3F] << 16 | byArray[n2 & 0x3F] << 24);
                break;
            }
            case 2: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] | byArray[n2 >>> 12 & 0x3F] << 8 | byArray[n2 >>> 6 & 0x3F] << 16 | 0x3D000000);
                break;
            }
            case 1: {
                byteBuf.setInt(n4, byArray[n2 >>> 18] | byArray[n2 >>> 12 & 0x3F] << 8 | 0x3D0000 | 0x3D000000);
                break;
            }
        }
    }

    public static ByteBuf decode(ByteBuf byteBuf) {
        return Base64.decode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ByteBuf byteBuf2 = Base64.decode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect) {
        return Base64.decode(byteBuf, n2, n3, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ObjectUtil.checkNotNull(base64Dialect, "dialect");
        return new Decoder().decode(byteBuf, n2, n3, byteBufAllocator, base64Dialect);
    }

    static int decodedBufferSize(int n2) {
        return n2 - (n2 >>> 2);
    }

    private static final class Decoder
    implements ByteProcessor {
        private final byte[] b4 = new byte[4];
        private int b4Posn;
        private byte[] decodabet;
        private int outBuffPosn;
        private ByteBuf dest;

        private Decoder() {
        }

        ByteBuf decode(ByteBuf byteBuf, int n2, int n3, ByteBufAllocator byteBufAllocator, Base64Dialect base64Dialect) {
            this.dest = byteBufAllocator.buffer(Base64.decodedBufferSize(n3)).order(byteBuf.order());
            this.decodabet = Base64.decodabet(base64Dialect);
            try {
                byteBuf.forEachByte(n2, n3, this);
                return this.dest.slice(0, this.outBuffPosn);
            }
            catch (Throwable throwable) {
                this.dest.release();
                PlatformDependent.throwException(throwable);
                return null;
            }
        }

        @Override
        public boolean process(byte by2) throws Exception {
            byte by3;
            if (by2 > 0 && (by3 = this.decodabet[by2]) >= -5) {
                if (by3 >= -1) {
                    this.b4[this.b4Posn++] = by2;
                    if (this.b4Posn > 3) {
                        this.outBuffPosn += Decoder.decode4to3(this.b4, this.dest, this.outBuffPosn, this.decodabet);
                        this.b4Posn = 0;
                        return by2 != 61;
                    }
                }
                return true;
            }
            throw new IllegalArgumentException("invalid Base64 input character: " + (short)(by2 & 0xFF) + " (decimal)");
        }

        private static int decode4to3(byte[] byArray, ByteBuf byteBuf, int n2, byte[] byArray2) {
            int n3;
            byte by2 = byArray[0];
            byte by3 = byArray[1];
            byte by4 = byArray[2];
            if (by4 == 61) {
                int n4;
                try {
                    n4 = (byArray2[by2] & 0xFF) << 2 | (byArray2[by3] & 0xFF) >>> 4;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("not encoded in Base64");
                }
                byteBuf.setByte(n2, n4);
                return 1;
            }
            byte by5 = byArray[3];
            if (by5 == 61) {
                int n5;
                byte by6 = byArray2[by3];
                try {
                    n5 = byteBuf.order() == ByteOrder.BIG_ENDIAN ? ((byArray2[by2] & 0x3F) << 2 | (by6 & 0xF0) >> 4) << 8 | (by6 & 0xF) << 4 | (byArray2[by4] & 0xFC) >>> 2 : (byArray2[by2] & 0x3F) << 2 | (by6 & 0xF0) >> 4 | ((by6 & 0xF) << 4 | (byArray2[by4] & 0xFC) >>> 2) << 8;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("not encoded in Base64");
                }
                byteBuf.setShort(n2, n5);
                return 2;
            }
            try {
                if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
                    n3 = (byArray2[by2] & 0x3F) << 18 | (byArray2[by3] & 0xFF) << 12 | (byArray2[by4] & 0xFF) << 6 | byArray2[by5] & 0xFF;
                } else {
                    byte by7 = byArray2[by3];
                    byte by8 = byArray2[by4];
                    n3 = (byArray2[by2] & 0x3F) << 2 | (by7 & 0xF) << 12 | (by7 & 0xF0) >>> 4 | (by8 & 3) << 22 | (by8 & 0xFC) << 6 | (byArray2[by5] & 0xFF) << 16;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("not encoded in Base64");
            }
            byteBuf.setMedium(n2, n3);
            return 3;
        }
    }
}

