/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.CodecOutputList;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.EncoderException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.PromiseCombiner;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher = TypeParameterMatcher.find(this, MessageToMessageEncoder.class, "I");

    protected MessageToMessageEncoder() {
    }

    public boolean acceptOutboundMessage(Object object) throws Exception {
        return this.matcher.match(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        block21: {
            CodecOutputList codecOutputList = null;
            try {
                if (this.acceptOutboundMessage(object)) {
                    codecOutputList = CodecOutputList.newInstance();
                    Object object2 = object;
                    try {
                        this.encode(channelHandlerContext, object2, codecOutputList);
                    }
                    catch (Throwable throwable) {
                        ReferenceCountUtil.safeRelease(object2);
                        PlatformDependent.throwException(throwable);
                    }
                    ReferenceCountUtil.release(object2);
                    if (codecOutputList.isEmpty()) {
                        throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                    }
                    break block21;
                }
                channelHandlerContext.write(object, channelPromise);
            }
            catch (EncoderException encoderException) {
                throw encoderException;
            }
            catch (Throwable throwable) {
                throw new EncoderException(throwable);
            }
            finally {
                if (codecOutputList != null) {
                    try {
                        int n2 = codecOutputList.size() - 1;
                        if (n2 == 0) {
                            channelHandlerContext.write(codecOutputList.getUnsafe(0), channelPromise);
                        } else if (n2 > 0) {
                            if (channelPromise == channelHandlerContext.voidPromise()) {
                                MessageToMessageEncoder.writeVoidPromise(channelHandlerContext, codecOutputList);
                            } else {
                                MessageToMessageEncoder.writePromiseCombiner(channelHandlerContext, codecOutputList, channelPromise);
                            }
                        }
                    }
                    finally {
                        codecOutputList.recycle();
                    }
                }
            }
        }
    }

    private static void writeVoidPromise(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList) {
        ChannelPromise channelPromise = channelHandlerContext.voidPromise();
        for (int i2 = 0; i2 < codecOutputList.size(); ++i2) {
            channelHandlerContext.write(codecOutputList.getUnsafe(i2), channelPromise);
        }
    }

    private static void writePromiseCombiner(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, ChannelPromise channelPromise) {
        PromiseCombiner promiseCombiner = new PromiseCombiner(channelHandlerContext.executor());
        for (int i2 = 0; i2 < codecOutputList.size(); ++i2) {
            promiseCombiner.add(channelHandlerContext.write(codecOutputList.getUnsafe(i2)));
        }
        promiseCombiner.finish(channelPromise);
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

