/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.util.AsciiString;

public final class HttpHeaderValidationUtil {
    private static final long TOKEN_CHARS_HIGH;
    private static final long TOKEN_CHARS_LOW;

    public static int validateValidHeaderValue(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return -1;
        }
        if (charSequence instanceof AsciiString) {
            return HttpHeaderValidationUtil.verifyValidHeaderValueAsciiString((AsciiString)charSequence);
        }
        return HttpHeaderValidationUtil.verifyValidHeaderValueCharSequence(charSequence);
    }

    private static int verifyValidHeaderValueAsciiString(AsciiString asciiString) {
        int n2;
        byte[] byArray = asciiString.array();
        int n3 = byArray[n2 = asciiString.arrayOffset()] & 0xFF;
        if (n3 < 33 || n3 == 127) {
            return 0;
        }
        int n4 = asciiString.length();
        for (int i2 = n2 + 1; i2 < n4; ++i2) {
            n3 = byArray[i2] & 0xFF;
            if ((n3 >= 32 || n3 == 9) && n3 != 127) continue;
            return i2 - n2;
        }
        return -1;
    }

    private static int verifyValidHeaderValueCharSequence(CharSequence charSequence) {
        char c2 = charSequence.charAt(0);
        if (c2 < '!' || c2 == '\u007f') {
            return 0;
        }
        int n2 = charSequence.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            c2 = charSequence.charAt(i2);
            if ((c2 >= ' ' || c2 == '\t') && c2 != '\u007f') continue;
            return i2;
        }
        return -1;
    }

    public static int validateToken(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return HttpHeaderValidationUtil.validateAsciiStringToken((AsciiString)charSequence);
        }
        return HttpHeaderValidationUtil.validateCharSequenceToken(charSequence);
    }

    private static int validateAsciiStringToken(AsciiString asciiString) {
        byte[] byArray = asciiString.array();
        int n2 = asciiString.arrayOffset() + asciiString.length();
        for (int i2 = asciiString.arrayOffset(); i2 < n2; ++i2) {
            if (BitSet128.contains(byArray[i2], TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i2 - asciiString.arrayOffset();
        }
        return -1;
    }

    private static int validateCharSequenceToken(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2 = (byte)charSequence.charAt(i2);
            if (BitSet128.contains(by2, TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i2;
        }
        return -1;
    }

    static {
        BitSet128 bitSet128 = new BitSet128().range('0', '9').range('a', 'z').range('A', 'Z').bits('-', '.', '_', '~').bits('!', '#', '$', '%', '&', '\'', '*', '+', '^', '`', '|');
        TOKEN_CHARS_HIGH = bitSet128.high();
        TOKEN_CHARS_LOW = bitSet128.low();
    }

    private static final class BitSet128 {
        private long high;
        private long low;

        private BitSet128() {
        }

        BitSet128 range(char n2, char c2) {
            for (int i2 = n2; i2 <= c2; ++i2) {
                if (i2 < 64) {
                    this.low |= 1L << i2;
                    continue;
                }
                this.high |= 1L << i2 - 64;
            }
            return this;
        }

        BitSet128 bits(char ... cArray) {
            for (char c2 : cArray) {
                if (c2 < '@') {
                    this.low |= 1L << c2;
                    continue;
                }
                this.high |= 1L << c2 - 64;
            }
            return this;
        }

        long high() {
            return this.high;
        }

        long low() {
            return this.low;
        }

        static boolean contains(byte by2, long l2, long l3) {
            if (by2 < 0) {
                return false;
            }
            if (by2 < 64) {
                return 0L != (l3 & 1L << by2);
            }
            return 0L != (l2 & 1L << by2 - 64);
        }
    }
}

