/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.IntPriorityQueue;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.LongLongHashMap;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolArena;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolChunkList;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolChunkMetric;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolSubpage;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolThreadCache;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PooledByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PooledByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.LongCounter;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;

final class PoolChunk<T>
implements PoolChunkMetric {
    final PoolArena<T> arena;
    final Object base;
    final T memory;
    final boolean unpooled;
    private final LongLongHashMap runsAvailMap;
    private final IntPriorityQueue[] runsAvail;
    private final ReentrantLock runsAvailLock;
    private final PoolSubpage<T>[] subpages;
    private final LongCounter pinnedBytes = PlatformDependent.newLongCounter();
    private final int pageSize;
    private final int pageShifts;
    private final int chunkSize;
    private final Deque<ByteBuffer> cachedNioBuffers;
    int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    PoolChunk(PoolArena<T> poolArena, Object object, T t2, int n2, int n3, int n4, int n5) {
        this.unpooled = false;
        this.arena = poolArena;
        this.base = object;
        this.memory = t2;
        this.pageSize = n2;
        this.pageShifts = n3;
        this.chunkSize = n4;
        this.freeBytes = n4;
        this.runsAvail = PoolChunk.newRunsAvailqueueArray(n5);
        this.runsAvailLock = new ReentrantLock();
        this.runsAvailMap = new LongLongHashMap(-1L);
        this.subpages = new PoolSubpage[n4 >> n3];
        int n6 = n4 >> n3;
        long l2 = (long)n6 << 34;
        this.insertAvailRun(0, n6, l2);
        this.cachedNioBuffers = new ArrayDeque<ByteBuffer>(8);
    }

    PoolChunk(PoolArena<T> poolArena, Object object, T t2, int n2) {
        this.unpooled = true;
        this.arena = poolArena;
        this.base = object;
        this.memory = t2;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.runsAvailMap = null;
        this.runsAvail = null;
        this.runsAvailLock = null;
        this.subpages = null;
        this.chunkSize = n2;
        this.cachedNioBuffers = null;
    }

    private static IntPriorityQueue[] newRunsAvailqueueArray(int n2) {
        IntPriorityQueue[] intPriorityQueueArray = new IntPriorityQueue[n2];
        for (int i2 = 0; i2 < intPriorityQueueArray.length; ++i2) {
            intPriorityQueueArray[i2] = new IntPriorityQueue();
        }
        return intPriorityQueueArray;
    }

    private void insertAvailRun(int n2, int n3, long l2) {
        int n4 = this.arena.sizeClass.pages2pageIdxFloor(n3);
        IntPriorityQueue intPriorityQueue = this.runsAvail[n4];
        assert (PoolChunk.isRun(l2));
        intPriorityQueue.offer((int)(l2 >> 32));
        this.insertAvailRun0(n2, l2);
        if (n3 > 1) {
            this.insertAvailRun0(PoolChunk.lastPage(n2, n3), l2);
        }
    }

    private void insertAvailRun0(int n2, long l2) {
        long l3 = this.runsAvailMap.put(n2, l2);
        assert (l3 == -1L);
    }

    private void removeAvailRun(long l2) {
        int n2 = this.arena.sizeClass.pages2pageIdxFloor(PoolChunk.runPages(l2));
        this.runsAvail[n2].remove((int)(l2 >> 32));
        this.removeAvailRun0(l2);
    }

    private void removeAvailRun0(long l2) {
        int n2 = PoolChunk.runOffset(l2);
        int n3 = PoolChunk.runPages(l2);
        this.runsAvailMap.remove(n2);
        if (n3 > 1) {
            this.runsAvailMap.remove(PoolChunk.lastPage(n2, n3));
        }
    }

    private static int lastPage(int n2, int n3) {
        return n2 + n3 - 1;
    }

    private long getAvailRunByOffset(int n2) {
        return this.runsAvailMap.get(n2);
    }

    public int usage() {
        int n2;
        if (this.unpooled) {
            n2 = this.freeBytes;
        } else {
            this.runsAvailLock.lock();
            try {
                n2 = this.freeBytes;
            }
            finally {
                this.runsAvailLock.unlock();
            }
        }
        return this.usage(n2);
    }

    private int usage(int n2) {
        if (n2 == 0) {
            return 100;
        }
        int n3 = (int)((long)n2 * 100L / (long)this.chunkSize);
        if (n3 == 0) {
            return 99;
        }
        return 100 - n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allocate(PooledByteBuf<T> pooledByteBuf, int n2, int n3, PoolThreadCache poolThreadCache) {
        long l2;
        block14: {
            if (n3 <= this.arena.sizeClass.smallMaxSizeIdx) {
                PoolSubpage poolSubpage = this.arena.smallSubpagePools[n3];
                poolSubpage.lock();
                try {
                    PoolSubpage poolSubpage2 = poolSubpage.next;
                    if (poolSubpage2 != poolSubpage) {
                        assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == this.arena.sizeClass.sizeIdx2size(n3)) : "doNotDestroy=" + poolSubpage2.doNotDestroy + ", elemSize=" + poolSubpage2.elemSize + ", sizeIdx=" + n3;
                        long l3 = poolSubpage2.allocate();
                        assert (l3 >= 0L);
                        assert (PoolChunk.isSubpage(l3));
                        poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, null, l3, n2, poolThreadCache);
                        boolean bl2 = true;
                        return bl2;
                    }
                    l2 = this.allocateSubpage(n3, poolSubpage);
                    if (l2 < 0L) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    assert (PoolChunk.isSubpage(l2));
                    break block14;
                }
                finally {
                    poolSubpage.unlock();
                }
            }
            int n4 = this.arena.sizeClass.sizeIdx2size(n3);
            l2 = this.allocateRun(n4);
            if (l2 < 0L) {
                return false;
            }
            assert (!PoolChunk.isSubpage(l2));
        }
        ByteBuffer byteBuffer = this.cachedNioBuffers != null ? this.cachedNioBuffers.pollLast() : null;
        this.initBuf(pooledByteBuf, byteBuffer, l2, n2, poolThreadCache);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateRun(int n2) {
        int n3 = n2 >> this.pageShifts;
        int n4 = this.arena.sizeClass.pages2pageIdx(n3);
        this.runsAvailLock.lock();
        try {
            int n5 = this.runFirstBestFit(n4);
            if (n5 == -1) {
                long l2 = -1L;
                return l2;
            }
            IntPriorityQueue intPriorityQueue = this.runsAvail[n5];
            long l3 = intPriorityQueue.poll();
            assert (l3 != -1L);
            assert (!PoolChunk.isUsed(l3 <<= 32)) : "invalid handle: " + l3;
            this.removeAvailRun0(l3);
            l3 = this.splitLargeRun(l3, n3);
            int n6 = PoolChunk.runSize(this.pageShifts, l3);
            this.freeBytes -= n6;
            long l4 = l3;
            return l4;
        }
        finally {
            this.runsAvailLock.unlock();
        }
    }

    private int calculateRunSize(int n2) {
        int n3;
        int n4 = 1 << this.pageShifts - 4;
        int n5 = 0;
        int n6 = this.arena.sizeClass.sizeIdx2size(n2);
        while ((n3 = (n5 += this.pageSize) / n6) < n4 && n5 != n3 * n6) {
        }
        while (n3 > n4) {
            n3 = (n5 -= this.pageSize) / n6;
        }
        assert (n3 > 0);
        assert (n5 <= this.chunkSize);
        assert (n5 >= n6);
        return n5;
    }

    private int runFirstBestFit(int n2) {
        if (this.freeBytes == this.chunkSize) {
            return this.arena.sizeClass.nPSizes - 1;
        }
        for (int i2 = n2; i2 < this.arena.sizeClass.nPSizes; ++i2) {
            IntPriorityQueue intPriorityQueue = this.runsAvail[i2];
            if (intPriorityQueue == null || intPriorityQueue.isEmpty()) continue;
            return i2;
        }
        return -1;
    }

    private long splitLargeRun(long l2, int n2) {
        assert (n2 > 0);
        int n3 = PoolChunk.runPages(l2);
        assert (n2 <= n3);
        int n4 = n3 - n2;
        if (n4 > 0) {
            int n5 = PoolChunk.runOffset(l2);
            int n6 = n5 + n2;
            long l3 = PoolChunk.toRunHandle(n6, n4, 0);
            this.insertAvailRun(n6, n4, l3);
            return PoolChunk.toRunHandle(n5, n2, 1);
        }
        return l2 |= 0x200000000L;
    }

    private long allocateSubpage(int n2, PoolSubpage<T> poolSubpage) {
        int n3 = this.calculateRunSize(n2);
        long l2 = this.allocateRun(n3);
        if (l2 < 0L) {
            return -1L;
        }
        int n4 = PoolChunk.runOffset(l2);
        assert (this.subpages[n4] == null);
        int n5 = this.arena.sizeClass.sizeIdx2size(n2);
        PoolSubpage<T> poolSubpage2 = new PoolSubpage<T>(poolSubpage, this, this.pageShifts, n4, PoolChunk.runSize(this.pageShifts, l2), n5);
        this.subpages[n4] = poolSubpage2;
        return poolSubpage2.allocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(long l2, int n2, ByteBuffer byteBuffer) {
        int n3;
        if (PoolChunk.isSubpage(l2)) {
            n3 = PoolChunk.runOffset(l2);
            PoolSubpage poolSubpage = this.subpages[n3];
            assert (poolSubpage != null);
            PoolSubpage poolSubpage2 = poolSubpage.chunk.arena.smallSubpagePools[poolSubpage.headIndex];
            poolSubpage2.lock();
            try {
                assert (poolSubpage.doNotDestroy);
                if (poolSubpage.free(poolSubpage2, PoolChunk.bitmapIdx(l2))) {
                    return;
                }
                assert (!poolSubpage.doNotDestroy);
                this.subpages[n3] = null;
            }
            finally {
                poolSubpage2.unlock();
            }
        }
        n3 = PoolChunk.runSize(this.pageShifts, l2);
        this.runsAvailLock.lock();
        try {
            long l3 = this.collapseRuns(l2);
            l3 &= 0xFFFFFFFDFFFFFFFFL;
            this.insertAvailRun(PoolChunk.runOffset(l3 &= 0xFFFFFFFEFFFFFFFFL), PoolChunk.runPages(l3), l3);
            this.freeBytes += n3;
        }
        finally {
            this.runsAvailLock.unlock();
        }
        if (byteBuffer != null && this.cachedNioBuffers != null && this.cachedNioBuffers.size() < PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK) {
            this.cachedNioBuffers.offer(byteBuffer);
        }
    }

    private long collapseRuns(long l2) {
        return this.collapseNext(this.collapsePast(l2));
    }

    private long collapsePast(long l2) {
        while (true) {
            int n2 = PoolChunk.runOffset(l2);
            int n3 = PoolChunk.runPages(l2);
            long l3 = this.getAvailRunByOffset(n2 - 1);
            if (l3 == -1L) {
                return l2;
            }
            int n4 = PoolChunk.runOffset(l3);
            int n5 = PoolChunk.runPages(l3);
            if (l3 == l2 || n4 + n5 != n2) break;
            this.removeAvailRun(l3);
            l2 = PoolChunk.toRunHandle(n4, n5 + n3, 0);
        }
        return l2;
    }

    private long collapseNext(long l2) {
        while (true) {
            int n2;
            int n3;
            long l3;
            if ((l3 = this.getAvailRunByOffset((n3 = PoolChunk.runOffset(l2)) + (n2 = PoolChunk.runPages(l2)))) == -1L) {
                return l2;
            }
            int n4 = PoolChunk.runOffset(l3);
            int n5 = PoolChunk.runPages(l3);
            if (l3 == l2 || n3 + n2 != n4) break;
            this.removeAvailRun(l3);
            l2 = PoolChunk.toRunHandle(n3, n2 + n5, 0);
        }
        return l2;
    }

    private static long toRunHandle(int n2, int n3, int n4) {
        return (long)n2 << 49 | (long)n3 << 34 | (long)n4 << 33;
    }

    void initBuf(PooledByteBuf<T> pooledByteBuf, ByteBuffer byteBuffer, long l2, int n2, PoolThreadCache poolThreadCache) {
        if (PoolChunk.isSubpage(l2)) {
            this.initBufWithSubpage(pooledByteBuf, byteBuffer, l2, n2, poolThreadCache);
        } else {
            int n3 = PoolChunk.runSize(this.pageShifts, l2);
            pooledByteBuf.init(this, byteBuffer, l2, PoolChunk.runOffset(l2) << this.pageShifts, n2, n3, this.arena.parent.threadCache());
        }
    }

    void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, ByteBuffer byteBuffer, long l2, int n2, PoolThreadCache poolThreadCache) {
        int n3 = PoolChunk.runOffset(l2);
        int n4 = PoolChunk.bitmapIdx(l2);
        PoolSubpage<T> poolSubpage = this.subpages[n3];
        assert (poolSubpage.isDoNotDestroy());
        assert (n2 <= poolSubpage.elemSize) : n2 + "<=" + poolSubpage.elemSize;
        int n5 = (n3 << this.pageShifts) + n4 * poolSubpage.elemSize;
        pooledByteBuf.init(this, byteBuffer, l2, n5, n2, poolSubpage.elemSize, poolThreadCache);
    }

    void incrementPinnedMemory(int n2) {
        assert (n2 > 0);
        this.pinnedBytes.add(n2);
    }

    void decrementPinnedMemory(int n2) {
        assert (n2 > 0);
        this.pinnedBytes.add(-n2);
    }

    @Override
    public int chunkSize() {
        return this.chunkSize;
    }

    public String toString() {
        int n2;
        if (this.unpooled) {
            n2 = this.freeBytes;
        } else {
            this.runsAvailLock.lock();
            try {
                n2 = this.freeBytes;
            }
            finally {
                this.runsAvailLock.unlock();
            }
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(n2) + "%, " + (this.chunkSize - n2) + '/' + this.chunkSize + ')';
    }

    void destroy() {
        this.arena.destroyChunk(this);
    }

    static int runOffset(long l2) {
        return (int)(l2 >> 49);
    }

    static int runSize(int n2, long l2) {
        return PoolChunk.runPages(l2) << n2;
    }

    static int runPages(long l2) {
        return (int)(l2 >> 34 & 0x7FFFL);
    }

    static boolean isUsed(long l2) {
        return (l2 >> 33 & 1L) == 1L;
    }

    static boolean isRun(long l2) {
        return !PoolChunk.isSubpage(l2);
    }

    static boolean isSubpage(long l2) {
        return (l2 >> 32 & 1L) == 1L;
    }

    static int bitmapIdx(long l2) {
        return (int)l2;
    }
}

