/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ByteBufInputStream
extends InputStream
implements DataInput {
    private final ByteBuf buffer;
    private final int startIndex;
    private final int endIndex;
    private boolean closed;
    private final boolean releaseOnClose;
    private StringBuilder lineBuf;

    public ByteBufInputStream(ByteBuf byteBuf, boolean bl2) {
        this(byteBuf, byteBuf.readableBytes(), bl2);
    }

    public ByteBufInputStream(ByteBuf byteBuf, int n2, boolean bl2) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        if (n2 < 0) {
            if (bl2) {
                byteBuf.release();
            }
            ObjectUtil.checkPositiveOrZero(n2, "length");
        }
        if (n2 > byteBuf.readableBytes()) {
            if (bl2) {
                byteBuf.release();
            }
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + n2 + ", maximum is " + byteBuf.readableBytes());
        }
        this.releaseOnClose = bl2;
        this.buffer = byteBuf;
        this.startIndex = byteBuf.readerIndex();
        this.endIndex = this.startIndex + n2;
        byteBuf.markReaderIndex();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.releaseOnClose && !this.closed) {
                this.closed = true;
                this.buffer.release();
            }
        }
    }

    @Override
    public int available() throws IOException {
        return this.endIndex - this.buffer.readerIndex();
    }

    @Override
    public void mark(int n2) {
        this.buffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.available();
        if (n2 == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.available();
        if (n4 == 0) {
            return -1;
        }
        n3 = Math.min(n4, n3);
        this.buffer.readBytes(byArray, n2, n3);
        return n3;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.resetReaderIndex();
    }

    @Override
    public long skip(long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)l2);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkAvailable(1);
        return this.read() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n2 = this.available();
        if (n2 == 0) {
            throw new EOFException();
        }
        return this.buffer.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.checkAvailable(n3);
        this.buffer.readBytes(byArray, n2, n3);
    }

    @Override
    public int readInt() throws IOException {
        this.checkAvailable(4);
        return this.buffer.readInt();
    }

    @Override
    public String readLine() throws IOException {
        int n2 = this.available();
        if (n2 == 0) {
            return null;
        }
        if (this.lineBuf != null) {
            this.lineBuf.setLength(0);
        }
        block4: while (true) {
            short s2 = this.buffer.readUnsignedByte();
            --n2;
            switch (s2) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (n2 <= 0 || (char)this.buffer.getUnsignedByte(this.buffer.readerIndex()) != '\n') break block4;
                    this.buffer.skipBytes(1);
                    --n2;
                    break block4;
                }
                default: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new StringBuilder();
                    }
                    this.lineBuf.append((char)s2);
                    if (n2 > 0) continue block4;
                }
            }
            break;
        }
        return this.lineBuf != null && this.lineBuf.length() > 0 ? this.lineBuf.toString() : "";
    }

    @Override
    public long readLong() throws IOException {
        this.checkAvailable(8);
        return this.buffer.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.checkAvailable(2);
        return this.buffer.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        int n3 = Math.min(this.available(), n2);
        this.buffer.skipBytes(n3);
        return n3;
    }

    private void checkAvailable(int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fieldSize cannot be a negative number");
        }
        if (n2 > this.available()) {
            throw new EOFException("fieldSize is too long! Length is " + n2 + ", but maximum is " + this.available());
        }
    }
}

