/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.internal.test;

import com.gradle.develocity.agent.gradle.internal.StateAccess;
import com.gradle.develocity.agent.gradle.internal.c.a;
import com.gradle.enterprise.gradleplugin.testacceleration.internal.b;
import com.gradle.enterprise.testacceleration.client.connector.f;
import com.gradle.enterprise.testacceleration.client.connector.r;
import com.gradle.enterprise.testacceleration.client.d;
import com.gradle.obfuscation.Keep;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;

@Keep
@DisableCachingByDefault(because="The task is used for troubleshooting, caching it would defeat the purpose.")
public abstract class TestDistributionWebSocketCheck
extends DefaultTask {
    public static final String NAME = "testDistributionWebSocketCheck";

    @Internal
    public abstract Property<Duration> getPingInterval();

    @Internal
    public abstract Property<Integer> getPingCount();

    @Internal
    public abstract Property<URI> getServer();

    @Option(option="websocket-allow-untrusted-server", description="Controls whether connections to servers with invalids certificates are allowed (default false)")
    @Internal
    public abstract Property<Boolean> getAllowUntrustedServer();

    @Internal
    abstract Property<f> getClientInfo();

    @Internal
    abstract Property<r> getUserOptions();

    @Option(option="websocket-ping-count", description="The amount of ping requests to send before closing the connection (default 10)")
    public void setPingCountAsString(String string) {
        try {
            this.getPingCount().set((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionValidationException("Could not parse option 'websocket-ping-count' value is not a valid integer.");
        }
    }

    @Option(option="websocket-ping-interval", description="The interval for sending ping requests (default 1s), supports either duration (ISO-8601 duration format PnDTnHnMn.nS) format or simple integer parse as seconds.")
    public void setIntervalAsString(String string) {
        try {
            this.getPingInterval().set((Object)Duration.parse(string));
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                this.getPingInterval().set((Object)Duration.ofSeconds(Long.parseLong(string)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new OptionValidationException("Could not parse option 'websocket-ping-interval' value to a Duration (ISO-8601 duration format PnDTnHnMn.nS).");
            }
        }
    }

    @Option(option="websocket-server", description="The server address for the Test Distribution Broker (default uses the same address as configured in the gradleEnterprise extension)")
    public void setServerAsString(String string) {
        try {
            this.getServer().set((Object)new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new OptionValidationException("Could not parse option 'websocket-server' value is not a valid URL.");
        }
    }

    @Inject
    public TestDistributionWebSocketCheck(ObjectFactory objectFactory, ProviderFactory providerFactory, Provider<StateAccess.c> provider, GradleInternal gradleInternal) {
        com.gradle.develocity.agent.gradle.internal.c.f f2 = new com.gradle.develocity.agent.gradle.internal.c.f(objectFactory, providerFactory);
        this.getServer().convention(b.a(f2, provider));
        this.getAllowUntrustedServer().convention(b.c(f2, provider));
        this.getClientInfo().convention((Object)f.a(com.gradle.enterprise.version.buildagent.a.GRADLE, "develocity.debug.client", a.a((Gradle)gradleInternal).agentVersion));
        this.getPingCount().convention((Object)10);
        this.getPingInterval().convention((Object)Duration.ofSeconds(1L));
        this.getUserOptions().convention(b.d(f2, provider));
    }

    @TaskAction
    void checkWebSocketConnection() throws ExecutionException, InterruptedException {
        d d2 = new d((f)this.getClientInfo().get(), (r)this.getUserOptions().get(), (URI)this.getServer().get(), (Boolean)this.getAllowUntrustedServer().get(), arg_0 -> ((Logger)this.getLogger()).lifecycle(arg_0));
        d2.a((Duration)this.getPingInterval().get(), (Integer)this.getPingCount().get());
    }
}

