/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.freebsd;

import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.FreeBsdLibc;
import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.freebsd.FreeBsdOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.unix.freebsd.BsdSysctlUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeBsdOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdOperatingSystem.class);
    private static final long BOOTTIME = FreeBsdOperatingSystem.querySystemBootTime();
    static final String PS_COMMAND_ARGS = Arrays.stream(PsKeywords.values()).map(Enum::name).map(string -> string.toLowerCase(Locale.ROOT)).collect(Collectors.joining(","));

    @Override
    public String queryManufacturer() {
        return "Unix/BSD";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String string = BsdSysctlUtil.sysctl("kern.ostype", "FreeBSD");
        String string2 = BsdSysctlUtil.sysctl("kern.osrelease", "");
        String string3 = BsdSysctlUtil.sysctl("kern.version", "");
        String string4 = string3.split(":")[0].replace(string, "").replace(string2, "").trim();
        return new Pair<String, OperatingSystem.OSVersionInfo>(string, new OperatingSystem.OSVersionInfo(string2, null, string4));
    }

    @Override
    protected int queryBitness(int n2) {
        if (n2 < 64 && ExecutingCommand.getFirstAnswer("uname -m").indexOf("64") == -1) {
            return n2;
        }
        return 64;
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.getProcessListFromPS(-1);
    }

    private List<OSProcess> getProcessListFromPS(int n2) {
        String string2 = "ps -awwxo " + PS_COMMAND_ARGS;
        if (n2 >= 0) {
            string2 = string2 + " -p " + n2;
        }
        Predicate<Map> predicate = map -> map.containsKey((Object)PsKeywords.ARGS);
        return ((Stream)ExecutingCommand.runNative(string2).stream().skip(1L).parallel()).map(string -> ParseUtil.stringToEnumMap(PsKeywords.class, string.trim(), ' ')).filter(predicate).map(map -> new FreeBsdOSProcess(n2 < 0 ? ParseUtil.parseIntOrDefault((String)map.get((Object)PsKeywords.PID), 0) : n2, (Map<PsKeywords, String>)map, this)).filter(OperatingSystem.ProcessFiltering.VALID_PROCESS).collect(Collectors.toList());
    }

    @Override
    public int getProcessId() {
        return FreeBsdLibc.INSTANCE.getpid();
    }

    private static long querySystemBootTime() {
        FreeBsdLibc.Timeval timeval = new FreeBsdLibc.Timeval();
        if (!BsdSysctlUtil.sysctl("kern.boottime", timeval) || timeval.tv_sec == 0L) {
            return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L);
        }
        return timeval.tv_sec;
    }

    static enum PsKeywords {
        STATE,
        PID,
        PPID,
        USER,
        UID,
        GROUP,
        GID,
        NLWP,
        PRI,
        VSZ,
        RSS,
        ETIMES,
        SYSTIME,
        TIME,
        COMM,
        MAJFLT,
        MINFLT,
        NVCSW,
        NIVCSW,
        ARGS;

    }
}

