/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.client.utils;

import com.gradle.scan.plugin.internal.dep.org.apache.http.Consts;
import com.gradle.scan.plugin.internal.dep.org.apache.http.NameValuePair;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.utils.URLEncodedUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.util.InetAddressUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.TextUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class URIBuilder {
    private String scheme;
    private String encodedSchemeSpecificPart;
    private String encodedAuthority;
    private String userInfo;
    private String encodedUserInfo;
    private String host;
    private int port;
    private String encodedPath;
    private List<String> pathSegments;
    private String encodedQuery;
    private List<NameValuePair> queryParams;
    private String query;
    private Charset charset;
    private String fragment;
    private String encodedFragment;

    public URIBuilder() {
        this.port = -1;
    }

    public URIBuilder(URI uRI) {
        this(uRI, null);
    }

    public URIBuilder(URI uRI, Charset charset) {
        this.setCharset(charset);
        this.digestURI(uRI);
    }

    public URIBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    private List<NameValuePair> parseQuery(String string, Charset charset) {
        if (string != null && !string.isEmpty()) {
            return URLEncodedUtils.parse(string, charset);
        }
        return null;
    }

    private List<String> parsePath(String string, Charset charset) {
        if (string != null && !string.isEmpty()) {
            return URLEncodedUtils.parsePathSegments(string, charset);
        }
        return null;
    }

    public URI build() throws URISyntaxException {
        return new URI(this.buildString());
    }

    private String buildString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheme != null) {
            stringBuilder.append(this.scheme).append(':');
        }
        if (this.encodedSchemeSpecificPart != null) {
            stringBuilder.append(this.encodedSchemeSpecificPart);
        } else {
            if (this.encodedAuthority != null) {
                stringBuilder.append("//").append(this.encodedAuthority);
            } else if (this.host != null) {
                stringBuilder.append("//");
                if (this.encodedUserInfo != null) {
                    stringBuilder.append(this.encodedUserInfo).append("@");
                } else if (this.userInfo != null) {
                    stringBuilder.append(this.encodeUserInfo(this.userInfo)).append("@");
                }
                if (InetAddressUtils.isIPv6Address(this.host)) {
                    stringBuilder.append("[").append(this.host).append("]");
                } else {
                    stringBuilder.append(this.host);
                }
                if (this.port >= 0) {
                    stringBuilder.append(":").append(this.port);
                }
            }
            if (this.encodedPath != null) {
                stringBuilder.append(URIBuilder.normalizePath(this.encodedPath, stringBuilder.length() == 0));
            } else if (this.pathSegments != null) {
                stringBuilder.append(this.encodePath(this.pathSegments));
            }
            if (this.encodedQuery != null) {
                stringBuilder.append("?").append(this.encodedQuery);
            } else if (this.queryParams != null && !this.queryParams.isEmpty()) {
                stringBuilder.append("?").append(this.encodeUrlForm(this.queryParams));
            } else if (this.query != null) {
                stringBuilder.append("?").append(this.encodeUric(this.query));
            }
        }
        if (this.encodedFragment != null) {
            stringBuilder.append("#").append(this.encodedFragment);
        } else if (this.fragment != null) {
            stringBuilder.append("#").append(this.encodeUric(this.fragment));
        }
        return stringBuilder.toString();
    }

    private static String normalizePath(String string, boolean bl2) {
        String string2 = string;
        if (TextUtils.isBlank(string2)) {
            return "";
        }
        if (!bl2 && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    private void digestURI(URI uRI) {
        this.scheme = uRI.getScheme();
        this.encodedSchemeSpecificPart = uRI.getRawSchemeSpecificPart();
        this.encodedAuthority = uRI.getRawAuthority();
        this.host = uRI.getHost();
        this.port = uRI.getPort();
        this.encodedUserInfo = uRI.getRawUserInfo();
        this.userInfo = uRI.getUserInfo();
        this.encodedPath = uRI.getRawPath();
        this.pathSegments = this.parsePath(uRI.getRawPath(), this.charset != null ? this.charset : Consts.UTF_8);
        this.encodedQuery = uRI.getRawQuery();
        this.queryParams = this.parseQuery(uRI.getRawQuery(), this.charset != null ? this.charset : Consts.UTF_8);
        this.encodedFragment = uRI.getRawFragment();
        this.fragment = uRI.getFragment();
    }

    private String encodeUserInfo(String string) {
        return URLEncodedUtils.encUserInfo(string, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodePath(List<String> list) {
        return URLEncodedUtils.formatSegments(list, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodeUrlForm(List<NameValuePair> list) {
        return URLEncodedUtils.format(list, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodeUric(String string) {
        return URLEncodedUtils.encUric(string, this.charset != null ? this.charset : Consts.UTF_8);
    }

    public URIBuilder setScheme(String string) {
        this.scheme = string;
        return this;
    }

    public URIBuilder setUserInfo(String string) {
        this.userInfo = string;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        this.encodedUserInfo = null;
        return this;
    }

    public URIBuilder setHost(String string) {
        this.host = string;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public URIBuilder setPort(int n2) {
        this.port = n2 < 0 ? -1 : n2;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public URIBuilder setPath(String string) {
        return this.setPathSegments(string != null ? URLEncodedUtils.splitPathSegments(string) : null);
    }

    public URIBuilder setPathSegments(String ... stringArray) {
        this.pathSegments = stringArray.length > 0 ? Arrays.asList(stringArray) : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        return this;
    }

    public URIBuilder setPathSegments(List<String> list) {
        this.pathSegments = list != null && list.size() > 0 ? new ArrayList<String>(list) : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        return this;
    }

    public URIBuilder addParameters(List<NameValuePair> list) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        this.queryParams.addAll(list);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder setFragment(String string) {
        this.fragment = string;
        this.encodedFragment = null;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isPathEmpty() {
        return !(this.pathSegments != null && !this.pathSegments.isEmpty() || this.encodedPath != null && !this.encodedPath.isEmpty());
    }

    public List<String> getPathSegments() {
        return this.pathSegments != null ? new ArrayList<String>(this.pathSegments) : new ArrayList();
    }

    public String getPath() {
        if (this.pathSegments == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.pathSegments) {
            stringBuilder.append('/').append(string);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.buildString();
    }
}

