/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression;

import com.github.luben.zstd.BaseZstdBufferDecompressingStreamNoFinalizer;
import com.github.luben.zstd.ZstdBufferDecompressingStreamNoFinalizer;
import com.github.luben.zstd.ZstdDirectBufferDecompressingStreamNoFinalizer;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.ByteToMessageDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.CompressionUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.DecompressionException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.Zstd;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final int outCapacity;
    private State currentState;
    private ZstdStream stream;

    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
            this.outCapacity = ZstdBufferDecompressingStreamNoFinalizer.recommendedTargetBufferSize();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.currentState = State.DECOMPRESS_DATA;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        try {
            if (this.currentState == State.CORRUPTED) {
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            int n2 = byteBuf.readableBytes();
            if (n2 == 0) {
                return;
            }
            if (this.stream == null) {
                this.stream = new ZstdStream(byteBuf.isDirect(), this.outCapacity);
            }
            do {
                ByteBuf byteBuf2;
                if ((byteBuf2 = this.stream.decompress(channelHandlerContext.alloc(), byteBuf)) == null) {
                    return;
                }
                list.add(byteBuf2);
            } while (byteBuf.isReadable());
        }
        catch (DecompressionException decompressionException) {
            this.currentState = State.CORRUPTED;
            throw decompressionException;
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    private static final class ZstdStream {
        private static final ByteBuffer EMPTY_HEAP_BUFFER = ByteBuffer.allocate(0);
        private static final ByteBuffer EMPTY_DIRECT_BUFFER = ByteBuffer.allocateDirect(0);
        private final boolean direct;
        private final int outCapacity;
        private final BaseZstdBufferDecompressingStreamNoFinalizer decompressingStream;
        private ByteBuffer current;

        ZstdStream(boolean bl2, int n2) {
            this.direct = bl2;
            this.outCapacity = n2;
            this.decompressingStream = bl2 ? new ZstdDirectBufferDecompressingStreamNoFinalizer(EMPTY_DIRECT_BUFFER){} : new ZstdBufferDecompressingStreamNoFinalizer(EMPTY_HEAP_BUFFER){};
        }

        ByteBuf decompress(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) throws DecompressionException {
            ByteBuf byteBuf2;
            if (this.direct && !byteBuf.isDirect()) {
                byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
            } else if (!this.direct && !byteBuf.hasArray()) {
                byteBuf2 = byteBufAllocator.heapBuffer(byteBuf.readableBytes());
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
            } else {
                byteBuf2 = byteBuf;
            }
            int n2 = -1;
            ReferenceCounted referenceCounted = null;
            try {
                ByteBuffer byteBuffer = CompressionUtil.safeNioBuffer(byteBuf2, byteBuf2.readerIndex(), byteBuf2.readableBytes());
                n2 = byteBuffer.position();
                assert (byteBuffer.hasRemaining());
                this.current = byteBuffer;
                referenceCounted = this.direct ? byteBufAllocator.directBuffer(this.outCapacity) : byteBufAllocator.heapBuffer(this.outCapacity);
                ByteBuffer byteBuffer2 = ((ByteBuf)referenceCounted).internalNioBuffer(((ByteBuf)referenceCounted).writerIndex(), ((ByteBuf)referenceCounted).writableBytes());
                int n3 = byteBuffer2.position();
                while (true) {
                    if (this.decompressingStream.read(byteBuffer2) != 0 && this.decompressingStream.hasRemaining() && byteBuffer2.hasRemaining() && this.current.hasRemaining()) {
                        continue;
                    }
                    int n4 = byteBuffer2.position() - n3;
                    if (n4 > 0) {
                        ((ByteBuf)referenceCounted).writerIndex(((ByteBuf)referenceCounted).writerIndex() + n4);
                        ReferenceCounted referenceCounted2 = referenceCounted;
                        referenceCounted = null;
                        ReferenceCounted referenceCounted3 = referenceCounted2;
                        return referenceCounted3;
                    }
                    if (!this.decompressingStream.hasRemaining() || !this.current.hasRemaining()) break;
                }
            }
            catch (IOException iOException) {
                throw new DecompressionException(iOException);
            }
            finally {
                int n5;
                if (referenceCounted != null) {
                    referenceCounted.release();
                }
                if (byteBuf2 != byteBuf) {
                    byteBuf2.release();
                }
                ByteBuffer byteBuffer = this.current;
                this.current = null;
                if (n2 != -1 && (n5 = byteBuffer.position() - n2) > 0) {
                    byteBuf.skipBytes(n5);
                }
            }
            return null;
        }

        void close() {
            this.decompressingStream.close();
        }
    }

    private static enum State {
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

