/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.Annotations;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.Field;

public final class FieldProperty
extends SettableBeanProperty {
    protected final AnnotatedField _annotated;
    protected final transient Field _field;
    protected final boolean _skipNulls;

    public FieldProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedField annotatedField) {
        super(beanPropertyDefinition, javaType, typeDeserializer, annotations);
        this._annotated = annotatedField;
        this._field = annotatedField.getAnnotated();
        this._skipNulls = NullsConstantProvider.isSkipper(this._nullProvider);
    }

    protected FieldProperty(FieldProperty fieldProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(fieldProperty, jsonDeserializer, nullValueProvider);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
        this._skipNulls = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    protected FieldProperty(FieldProperty fieldProperty, PropertyName propertyName) {
        super(fieldProperty, propertyName);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
        this._skipNulls = fieldProperty._skipNulls;
    }

    @Override
    public SettableBeanProperty withName(PropertyName propertyName) {
        return new FieldProperty(this, propertyName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._valueDeserializer == jsonDeserializer) {
            return this;
        }
        NullValueProvider nullValueProvider = this._valueDeserializer == this._nullProvider ? jsonDeserializer : this._nullProvider;
        return new FieldProperty(this, jsonDeserializer, nullValueProvider);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        return new FieldProperty(this, this._valueDeserializer, nullValueProvider);
    }

    @Override
    public void fixAccess(DeserializationConfig deserializationConfig) {
        ClassUtil.checkAndFixAccess(this._field, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Object object2;
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            object2 = this._nullProvider.getNullValue(deserializationContext);
        } else if (this._valueTypeDeserializer == null) {
            object2 = this._valueDeserializer.deserialize(jsonParser, deserializationContext);
            if (object2 == null) {
                if (this._skipNulls) {
                    return;
                }
                object2 = this._nullProvider.getNullValue(deserializationContext);
            }
        } else {
            object2 = this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(jsonParser, exception, object2);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Object object2;
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return object;
            }
            object2 = this._nullProvider.getNullValue(deserializationContext);
        } else if (this._valueTypeDeserializer == null) {
            object2 = this._valueDeserializer.deserialize(jsonParser, deserializationContext);
            if (object2 == null) {
                if (this._skipNulls) {
                    return object;
                }
                object2 = this._nullProvider.getNullValue(deserializationContext);
            }
        } else {
            object2 = this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(jsonParser, exception, object2);
        }
        return object;
    }

    @Override
    public void set(Object object, Object object2) throws IOException {
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
        }
    }

    @Override
    public Object setAndReturn(Object object, Object object2) throws IOException {
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
        }
        return object;
    }
}

