/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.CipherSuiteFilter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ClientAuth;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslServerSessionContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslContextOption;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public final class OpenSslServerContext
extends OpenSslContext {
    private final OpenSslServerSessionContext sessionContext;

    OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, String string2, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l2, l3, clientAuth, stringArray, bl2, bl3, string2, entryArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, String string2, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, 1, (Certificate[])x509CertificateArray2, clientAuth, stringArray, bl2, bl3, entryArray);
        boolean bl4 = false;
        try {
            OpenSslKeyMaterialProvider.validateKeyMaterialSupported(x509CertificateArray2, privateKey, string);
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l2, l3);
            bl4 = true;
        }
        finally {
            if (!bl4) {
                this.release();
            }
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }
}

