/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.OptBoolean;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface JsonTypeInfo {
    public Id use();

    public As include() default As.PROPERTY;

    public String property() default "";

    public Class<?> defaultImpl() default JsonTypeInfo.class;

    public boolean visible() default false;

    public OptBoolean requireTypeIdForSubtypes() default OptBoolean.DEFAULT;

    public static class Value
    implements Serializable {
        protected static final Value EMPTY = new Value(Id.NONE, As.PROPERTY, null, null, false, null);
        protected final Id _idType;
        protected final As _inclusionType;
        protected final String _propertyName;
        protected final Class<?> _defaultImpl;
        protected final boolean _idVisible;
        protected final Boolean _requireTypeIdForSubtypes;

        protected Value(Id id2, As as2, String string, Class<?> clazz, boolean bl2, Boolean bl3) {
            this._defaultImpl = clazz;
            this._idType = id2;
            this._inclusionType = as2;
            this._propertyName = string;
            this._idVisible = bl2;
            this._requireTypeIdForSubtypes = bl3;
        }

        public static Value construct(Id id2, As as2, String string, Class<?> clazz, boolean bl2, Boolean bl3) {
            if (string == null || string.isEmpty()) {
                string = id2 != null ? id2.getDefaultPropertyName() : "";
            }
            if (clazz == null || clazz.isAnnotation()) {
                clazz = null;
            }
            return new Value(id2, as2, string, clazz, bl2, bl3);
        }

        public static Value from(JsonTypeInfo jsonTypeInfo) {
            if (jsonTypeInfo == null) {
                return null;
            }
            return Value.construct(jsonTypeInfo.use(), jsonTypeInfo.include(), jsonTypeInfo.property(), jsonTypeInfo.defaultImpl(), jsonTypeInfo.visible(), jsonTypeInfo.requireTypeIdForSubtypes().asBoolean());
        }

        public Value withDefaultImpl(Class<?> clazz) {
            return clazz == this._defaultImpl ? this : new Value(this._idType, this._inclusionType, this._propertyName, clazz, this._idVisible, this._requireTypeIdForSubtypes);
        }

        public Value withInclusionType(As as2) {
            return as2 == this._inclusionType ? this : new Value(this._idType, as2, this._propertyName, this._defaultImpl, this._idVisible, this._requireTypeIdForSubtypes);
        }

        public Class<?> getDefaultImpl() {
            return this._defaultImpl;
        }

        public Id getIdType() {
            return this._idType;
        }

        public As getInclusionType() {
            return this._inclusionType;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public boolean getIdVisible() {
            return this._idVisible;
        }

        public Boolean getRequireTypeIdForSubtypes() {
            return this._requireTypeIdForSubtypes;
        }

        public String toString() {
            return String.format("JsonTypeInfo.Value(idType=%s,includeAs=%s,propertyName=%s,defaultImpl=%s,idVisible=%s,requireTypeIdForSubtypes=%s)", new Object[]{this._idType, this._inclusionType, this._propertyName, this._defaultImpl == null ? "NULL" : this._defaultImpl.getName(), this._idVisible, this._requireTypeIdForSubtypes});
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + (this._idType != null ? this._idType.hashCode() : 0);
            n2 = 31 * n2 + (this._inclusionType != null ? this._inclusionType.hashCode() : 0);
            n2 = 31 * n2 + (this._propertyName != null ? this._propertyName.hashCode() : 0);
            n2 = 31 * n2 + (this._defaultImpl != null ? this._defaultImpl.hashCode() : 0);
            n2 = 31 * n2 + (this._requireTypeIdForSubtypes != false ? 11 : -17);
            n2 = 31 * n2 + (this._idVisible ? 11 : -17);
            return n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return object.getClass() == this.getClass() && Value._equals(this, (Value)object);
        }

        private static boolean _equals(Value value, Value value2) {
            return value._idType == value2._idType && value._inclusionType == value2._inclusionType && value._defaultImpl == value2._defaultImpl && value._idVisible == value2._idVisible && Value._equal(value._propertyName, value2._propertyName) && Value._equal(value._requireTypeIdForSubtypes, value2._requireTypeIdForSubtypes);
        }

        private static <T> boolean _equal(T t2, T t3) {
            if (t2 == null) {
                return t3 == null;
            }
            if (t3 == null) {
                return false;
            }
            return t2.equals(t3);
        }
    }

    @Deprecated
    public static abstract class None {
    }

    public static enum As {
        PROPERTY,
        WRAPPER_OBJECT,
        WRAPPER_ARRAY,
        EXTERNAL_PROPERTY,
        EXISTING_PROPERTY;

    }

    public static enum Id {
        NONE(null),
        CLASS("@class"),
        MINIMAL_CLASS("@c"),
        NAME("@type"),
        SIMPLE_NAME("@type"),
        DEDUCTION(null),
        CUSTOM(null);

        private final String _defaultPropertyName;

        private Id(String string2) {
            this._defaultPropertyName = string2;
        }

        public String getDefaultPropertyName() {
            return this._defaultPropertyName;
        }
    }
}

