/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.maven.adapters.develocity;

import com.gradle.develocity.agent.maven.adapters.BuildCacheApiAdapter;
import com.gradle.develocity.agent.maven.adapters.LocalBuildCacheAdapter;
import com.gradle.develocity.agent.maven.adapters.MojoMetadataProviderAdapter;
import com.gradle.develocity.agent.maven.adapters.NormalizationProviderAdapter;
import com.gradle.develocity.agent.maven.adapters.Property;
import com.gradle.develocity.agent.maven.adapters.RemoteBuildCacheAdapter;
import com.gradle.develocity.agent.maven.adapters.develocity.DevelocityMojoMetadataContext;
import com.gradle.develocity.agent.maven.adapters.develocity.DevelocityNormalizationContext;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultCleanupPolicyAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultCredentialsAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultLocalBuildCacheAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultRemoteBuildCacheAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultServerAdapter;
import com.gradle.develocity.agent.maven.api.cache.BuildCacheApi;
import com.gradle.develocity.agent.maven.api.cache.CleanupPolicy;
import com.gradle.develocity.agent.maven.api.cache.Credentials;
import com.gradle.develocity.agent.maven.api.cache.LocalBuildCache;
import com.gradle.develocity.agent.maven.api.cache.RemoteBuildCache;
import com.gradle.develocity.agent.maven.api.cache.Server;

class DevelocityBuildCacheApiAdapter
implements BuildCacheApiAdapter {
    private final BuildCacheApi buildCache;
    private final LocalBuildCacheAdapter localCache;
    private final RemoteBuildCacheAdapter remoteCache;

    DevelocityBuildCacheApiAdapter(BuildCacheApi buildCache) {
        this.buildCache = buildCache;
        this.localCache = DevelocityBuildCacheApiAdapter.createLocalCacheAdapter(buildCache);
        this.remoteCache = DevelocityBuildCacheApiAdapter.createRemoteCacheAdapter(buildCache);
    }

    private static DefaultLocalBuildCacheAdapter createLocalCacheAdapter(BuildCacheApi buildCache) {
        LocalBuildCache local = buildCache.getLocal();
        CleanupPolicy cleanupPolicy = local.getCleanupPolicy();
        return new DefaultLocalBuildCacheAdapter(Property.create(arg_0 -> ((LocalBuildCache)local).setEnabled(arg_0), () -> ((LocalBuildCache)local).isEnabled()), Property.create(arg_0 -> ((LocalBuildCache)local).setStoreEnabled(arg_0), () -> ((LocalBuildCache)local).isStoreEnabled()), Property.create(arg_0 -> ((LocalBuildCache)local).setDirectory(arg_0), () -> ((LocalBuildCache)local).getDirectory()), new DefaultCleanupPolicyAdapter(Property.create(arg_0 -> ((CleanupPolicy)cleanupPolicy).setEnabled(arg_0), () -> ((CleanupPolicy)cleanupPolicy).isEnabled()), Property.create(arg_0 -> ((CleanupPolicy)cleanupPolicy).setRetentionPeriod(arg_0), () -> ((CleanupPolicy)cleanupPolicy).getRetentionPeriod()), Property.create(arg_0 -> ((CleanupPolicy)cleanupPolicy).setCleanupInterval(arg_0), () -> ((CleanupPolicy)cleanupPolicy).getCleanupInterval())));
    }

    private static DefaultRemoteBuildCacheAdapter createRemoteCacheAdapter(BuildCacheApi buildCache) {
        RemoteBuildCache remote = buildCache.getRemote();
        Server server = remote.getServer();
        return new DefaultRemoteBuildCacheAdapter(Property.create(arg_0 -> ((RemoteBuildCache)remote).setEnabled(arg_0), () -> ((RemoteBuildCache)remote).isEnabled()), Property.create(arg_0 -> ((RemoteBuildCache)remote).setStoreEnabled(arg_0), () -> ((RemoteBuildCache)remote).isStoreEnabled()), DevelocityBuildCacheApiAdapter.createServerAdapter(server));
    }

    private static DefaultServerAdapter createServerAdapter(Server server) {
        Credentials credentials = server.getCredentials();
        return new DefaultServerAdapter(Property.create(arg_0 -> ((Server)server).setServerId(arg_0), () -> ((Server)server).getServerId()), Property.create(arg_0 -> ((Server)server).setUrl(arg_0), () -> ((Server)server).getUrl()), Property.create(arg_0 -> ((Server)server).setAllowUntrusted(arg_0), () -> ((Server)server).isAllowUntrusted()), Property.create(arg_0 -> ((Server)server).setAllowInsecureProtocol(arg_0), () -> ((Server)server).isAllowInsecureProtocol()), Property.create(arg_0 -> ((Server)server).setUseExpectContinue(arg_0), () -> ((Server)server).isUseExpectContinue()), new DefaultCredentialsAdapter(Property.create(arg_0 -> ((Credentials)credentials).setUsername(arg_0), () -> ((Credentials)credentials).getUsername()), Property.create(arg_0 -> ((Credentials)credentials).setPassword(arg_0), () -> ((Credentials)credentials).getPassword())));
    }

    @Override
    public LocalBuildCacheAdapter getLocal() {
        return this.localCache;
    }

    @Override
    public RemoteBuildCacheAdapter getRemote() {
        return this.remoteCache;
    }

    @Override
    public boolean isRequireClean() {
        return this.buildCache.isRequireClean();
    }

    @Override
    public void setRequireClean(boolean requireClean) {
        this.buildCache.setRequireClean(requireClean);
    }

    @Override
    public void registerMojoMetadataProvider(MojoMetadataProviderAdapter metadataProvider) {
        this.buildCache.registerMojoMetadataProvider(ctx -> metadataProvider.provideMetadata(new DevelocityMojoMetadataContext(ctx)));
    }

    @Override
    public void registerNormalizationProvider(NormalizationProviderAdapter normalizationProvider) {
        this.buildCache.registerNormalizationProvider(ctx -> normalizationProvider.configureNormalization(new DevelocityNormalizationContext(ctx)));
    }
}

