/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.maven.adapters.develocity;

import com.gradle.develocity.agent.maven.adapters.BuildResultAdapter;
import com.gradle.develocity.agent.maven.adapters.BuildScanApiAdapter;
import com.gradle.develocity.agent.maven.adapters.BuildScanCaptureAdapter;
import com.gradle.develocity.agent.maven.adapters.BuildScanDataObfuscationAdapter;
import com.gradle.develocity.agent.maven.adapters.Property;
import com.gradle.develocity.agent.maven.adapters.PublishedBuildScanAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultBuildResultAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultBuildScanCaptureAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultBuildScanDataObfuscationAdapter;
import com.gradle.develocity.agent.maven.adapters.shared.DefaultPublishedBuildScanAdapter;
import com.gradle.develocity.agent.maven.api.scan.BuildScanApi;
import com.gradle.develocity.agent.maven.api.scan.BuildScanCaptureSettings;
import com.gradle.develocity.agent.maven.api.scan.BuildScanDataObfuscation;
import java.net.URI;
import java.util.function.Consumer;

class DevelocityBuildScanApiAdapter
implements BuildScanApiAdapter {
    private final BuildScanApi buildScan;
    private final BuildScanDataObfuscationAdapter obfuscation;
    private final BuildScanCaptureAdapter capture;

    DevelocityBuildScanApiAdapter(BuildScanApi buildScan) {
        this.buildScan = buildScan;
        this.obfuscation = new DefaultBuildScanDataObfuscationAdapter(arg_0 -> ((BuildScanDataObfuscation)buildScan.getObfuscation()).username(arg_0), arg_0 -> ((BuildScanDataObfuscation)buildScan.getObfuscation()).hostname(arg_0), arg_0 -> ((BuildScanDataObfuscation)buildScan.getObfuscation()).ipAddresses(arg_0));
        this.capture = new DefaultBuildScanCaptureAdapter(Property.create(arg_0 -> ((BuildScanCaptureSettings)buildScan.getCapture()).setFileFingerprints(arg_0), () -> ((BuildScanCaptureSettings)buildScan.getCapture()).isFileFingerprints()), Property.create(arg_0 -> ((BuildScanCaptureSettings)buildScan.getCapture()).setBuildLogging(arg_0), () -> ((BuildScanCaptureSettings)buildScan.getCapture()).isBuildLogging()), Property.create(arg_0 -> ((BuildScanCaptureSettings)buildScan.getCapture()).setTestLogging(arg_0), () -> ((BuildScanCaptureSettings)buildScan.getCapture()).isTestLogging()));
    }

    @Override
    public void tag(String tag) {
        this.buildScan.tag(tag);
    }

    @Override
    public void value(String name, String value) {
        this.buildScan.value(name, value);
    }

    @Override
    public void link(String name, String url) {
        this.buildScan.link(name, url);
    }

    @Override
    public void background(Consumer<? super BuildScanApiAdapter> action) {
        this.buildScan.background(__ -> action.accept(this));
    }

    @Override
    public void buildFinished(Consumer<? super BuildResultAdapter> action) {
        this.buildScan.buildFinished(result -> action.accept(new DefaultBuildResultAdapter(result.getFailures())));
    }

    @Override
    public void buildScanPublished(Consumer<? super PublishedBuildScanAdapter> action) {
        this.buildScan.buildScanPublished(scan -> action.accept(new DefaultPublishedBuildScanAdapter(scan.getBuildScanId(), scan.getBuildScanUri())));
    }

    @Override
    public void setTermsOfUseUrl(String termsOfServiceUrl) {
        this.buildScan.setTermsOfUseUrl(termsOfServiceUrl);
    }

    @Override
    public String getTermsOfUseUrl() {
        return this.buildScan.getTermsOfUseUrl();
    }

    @Override
    public void setTermsOfUseAgree(String agree) {
        this.buildScan.setTermsOfUseAgree(agree);
    }

    @Override
    public String getTermsOfUseAgree() {
        return this.buildScan.getTermsOfUseAgree();
    }

    @Override
    public void setServer(URI url) {
        this.buildScan.setServer(url);
    }

    @Override
    public String getServer() {
        return this.buildScan.getServer();
    }

    @Override
    public void setAllowUntrustedServer(boolean allow) {
        this.buildScan.setAllowUntrustedServer(allow);
    }

    @Override
    public boolean getAllowUntrustedServer() {
        return this.buildScan.getAllowUntrustedServer();
    }

    @Override
    public void publishAlways() {
        this.buildScan.publishing(p -> p.onlyIf(ctx -> true));
    }

    @Override
    public void publishAlwaysIf(boolean condition) {
        this.buildScan.publishing(p -> p.onlyIf(ctx -> condition));
    }

    @Override
    public void publishOnFailure() {
        this.buildScan.publishing(p -> p.onlyIf(ctx -> !ctx.getBuildResult().getFailures().isEmpty()));
    }

    @Override
    public void publishOnFailureIf(boolean condition) {
        this.buildScan.publishing(p -> p.onlyIf(ctx -> !ctx.getBuildResult().getFailures().isEmpty() && condition));
    }

    @Override
    public void publishOnDemand() {
        this.buildScan.publishing(p -> p.onlyIf(ctx -> false));
    }

    @Override
    public void setUploadInBackground(boolean uploadInBackground) {
        this.buildScan.setUploadInBackground(uploadInBackground);
    }

    @Override
    public boolean isUploadInBackground() {
        return this.buildScan.isUploadInBackground();
    }

    @Override
    public void executeOnce(String identifier, Consumer<? super BuildScanApiAdapter> action) {
        this.buildScan.executeOnce(identifier, __ -> action.accept(this));
    }

    @Override
    public BuildScanDataObfuscationAdapter getObfuscation() {
        return this.obfuscation;
    }

    @Override
    public BuildScanCaptureAdapter getCapture() {
        return this.capture;
    }
}

