/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.maven.extension.api.GradleEnterpriseApi;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.logging.Logger;

final class GroovyScriptUserData {
    static void evaluate(MavenSession session, GradleEnterpriseApi gradleEnterprise, Logger logger) throws MavenExecutionException {
        File groovyScript = GroovyScriptUserData.getGroovyScript(session);
        if (groovyScript.exists()) {
            logger.debug("Evaluating custom user data Groovy script: " + groovyScript);
            GroovyScriptUserData.evaluateGroovyScript(session, gradleEnterprise, logger, groovyScript);
        } else {
            logger.debug("Skipping evaluation of custom user data Groovy script because it does not exist: " + groovyScript);
        }
    }

    private static File getGroovyScript(MavenSession session) {
        File rootDir = session.getRequest().getMultiModuleProjectDirectory();
        return new File(rootDir, ".mvn/gradle-enterprise-custom-user-data.groovy");
    }

    private static void evaluateGroovyScript(MavenSession session, GradleEnterpriseApi gradleEnterprise, Logger logger, File groovyScript) throws MavenExecutionException {
        try {
            Binding binding = GroovyScriptUserData.prepareBinding(session, gradleEnterprise, logger);
            new GroovyShell(GroovyScriptUserData.class.getClassLoader(), binding).evaluate(groovyScript);
        }
        catch (Exception e) {
            throw new MavenExecutionException("Failed to evaluate custom user data Groovy script: " + groovyScript, (Throwable)e);
        }
    }

    private static Binding prepareBinding(MavenSession session, GradleEnterpriseApi gradleEnterprise, Logger logger) {
        Binding binding = new Binding();
        binding.setVariable("project", session.getTopLevelProject());
        binding.setVariable("session", session);
        binding.setVariable("gradleEnterprise", gradleEnterprise);
        binding.setVariable("buildScan", gradleEnterprise.getBuildScan());
        binding.setVariable("buildCache", gradleEnterprise.getBuildCache());
        binding.setVariable("log", new MavenLogger(logger));
        return binding;
    }

    private GroovyScriptUserData() {
    }

    private static final class MavenLogger
    implements Log {
        private final Logger plexusLogger;

        private MavenLogger(Logger plexusLogger) {
            this.plexusLogger = plexusLogger;
        }

        public void debug(CharSequence content) {
            this.plexusLogger.debug(this.toString(content));
        }

        private String toString(CharSequence content) {
            return content == null ? "" : content.toString();
        }

        public void debug(CharSequence content, Throwable error) {
            this.plexusLogger.debug(this.toString(content), error);
        }

        public void debug(Throwable error) {
            this.plexusLogger.debug("", error);
        }

        public void info(CharSequence content) {
            this.plexusLogger.info(this.toString(content));
        }

        public void info(CharSequence content, Throwable error) {
            this.plexusLogger.info(this.toString(content), error);
        }

        public void info(Throwable error) {
            this.plexusLogger.info("", error);
        }

        public void warn(CharSequence content) {
            this.plexusLogger.warn(this.toString(content));
        }

        public void warn(CharSequence content, Throwable error) {
            this.plexusLogger.warn(this.toString(content), error);
        }

        public void warn(Throwable error) {
            this.plexusLogger.warn("", error);
        }

        public void error(CharSequence content) {
            this.plexusLogger.error(this.toString(content));
        }

        public void error(CharSequence content, Throwable error) {
            this.plexusLogger.error(this.toString(content), error);
        }

        public void error(Throwable error) {
            this.plexusLogger.error("", error);
        }

        public boolean isDebugEnabled() {
            return this.plexusLogger.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.plexusLogger.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.plexusLogger.isWarnEnabled();
        }

        public boolean isErrorEnabled() {
            return this.plexusLogger.isErrorEnabled();
        }
    }
}

