/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.ApiAccessor;
import com.gradle.CustomBuildScanEnhancements;
import com.gradle.CustomGradleEnterpriseConfig;
import com.gradle.GroovyScriptUserData;
import com.gradle.maven.extension.api.cache.BuildCacheApi;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import javax.inject.Inject;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="common-custom-user-data", description="Captures common custom user data in Maven build scans")
public final class CommonCustomUserDataMavenExtension
extends AbstractMavenLifecycleParticipant {
    private final PlexusContainer container;
    private final Logger logger;

    @Inject
    public CommonCustomUserDataMavenExtension(PlexusContainer container, Logger logger) {
        this.container = container;
        this.logger = logger;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        BuildCacheApi buildCache;
        this.logger.debug("Executing extension: " + ((Object)((Object)this)).getClass().getSimpleName());
        BuildScanApi buildScan = ApiAccessor.lookupBuildScanApi(this.container, ((Object)((Object)this)).getClass());
        if (buildScan != null) {
            this.logger.debug("Configuring build scan publishing");
            CustomGradleEnterpriseConfig.configureBuildScanPublishing(buildScan);
            this.logger.debug("Finished configuring build scan publishing");
            this.logger.debug("Applying build scan enhancements");
            CustomBuildScanEnhancements.configureBuildScan(buildScan, session);
            this.logger.debug("Finished applying build scan enhancements");
        }
        if ((buildCache = ApiAccessor.lookupBuildCacheApi(this.container, ((Object)((Object)this)).getClass())) != null) {
            this.logger.debug("Configuring build cache");
            CustomGradleEnterpriseConfig.configureBuildCache(buildCache);
            this.logger.debug("Finished configuring build cache");
        }
        if (buildScan != null || buildCache != null) {
            GroovyScriptUserData.addToApis(session, buildScan, buildCache, this.logger);
        } else {
            this.logger.debug("Skipping evaluation of custom user data Groovy script because BuildScanApi and BuildCacheApi are both not available");
        }
    }
}

