/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class CustomUserData {
    static void addToBuildScan(BuildScanApi buildScan) {
        CustomUserData.tagOs(buildScan);
        CustomUserData.tagIde(buildScan);
        CustomUserData.tagCiOrLocal(buildScan);
        CustomUserData.addCiMetadata(buildScan);
        CustomUserData.addGitMetadata(buildScan);
    }

    private static void tagOs(BuildScanApi buildScan) {
        buildScan.tag(CustomUserData.sysProperty("os.name"));
    }

    private static void tagIde(BuildScanApi buildScan) {
        if (CustomUserData.sysPropertyPresent("idea.version") || CustomUserData.sysPropertyKeyStartingWith("idea.version")) {
            buildScan.tag("IntelliJ IDEA");
        } else if (CustomUserData.sysPropertyPresent("eclipse.buildId")) {
            buildScan.tag("Eclipse");
        } else if (!CustomUserData.isCi()) {
            buildScan.tag("Cmd Line");
        }
    }

    private static void tagCiOrLocal(BuildScanApi buildScan) {
        buildScan.tag(CustomUserData.isCi() ? "CI" : "LOCAL");
    }

    private static void addCiMetadata(BuildScanApi buildScan) {
        String stageName;
        String stageNameLabel;
        String jobName;
        String jobNameLabel;
        if (CustomUserData.isJenkins()) {
            if (CustomUserData.envVariablePresent("BUILD_URL")) {
                buildScan.link("Jenkins build", CustomUserData.envVariable("BUILD_URL"));
            }
            if (CustomUserData.envVariablePresent("BUILD_NUMBER")) {
                buildScan.value("CI build number", CustomUserData.envVariable("BUILD_NUMBER"));
            }
            if (CustomUserData.envVariablePresent("NODE_NAME")) {
                String nodeNameLabel = "CI node";
                String nodeName = CustomUserData.envVariable("NODE_NAME");
                buildScan.value(nodeNameLabel, nodeName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI node build scans", (Map<String, String>)ImmutableMap.of((Object)nodeNameLabel, (Object)nodeName));
            }
            if (CustomUserData.envVariablePresent("JOB_NAME")) {
                jobNameLabel = "CI job";
                jobName = CustomUserData.envVariable("JOB_NAME");
                buildScan.value(jobNameLabel, jobName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI job build scans", (Map<String, String>)ImmutableMap.of((Object)jobNameLabel, (Object)jobName));
            }
            if (CustomUserData.envVariablePresent("STAGE_NAME")) {
                stageNameLabel = "CI stage";
                stageName = CustomUserData.envVariable("STAGE_NAME");
                buildScan.value(stageNameLabel, stageName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI stage build scans", (Map<String, String>)ImmutableMap.of((Object)stageNameLabel, (Object)stageName));
            }
        }
        if (CustomUserData.isTeamCity()) {
            Properties properties;
            String teamCityServerUrl;
            if (CustomUserData.sysPropertyPresent("teamcity.configuration.properties.file") && (teamCityServerUrl = (properties = CustomUserData.readPropertiesFile(CustomUserData.sysProperty("teamcity.configuration.properties.file"))).getProperty("teamcity.serverUrl")) != null && CustomUserData.sysPropertyPresent("build.number") && CustomUserData.sysPropertyPresent("teamcity.buildType.id")) {
                String buildNumber = CustomUserData.sysProperty("build.number");
                String buildTypeId = CustomUserData.sysProperty("teamcity.buildType.id");
                buildScan.link("TeamCity build", CustomUserData.appendIfMissing(teamCityServerUrl, "/") + "viewLog.html?buildNumber=" + buildNumber + "&buildTypeId=" + buildTypeId);
            }
            if (CustomUserData.sysPropertyPresent("build.number")) {
                buildScan.value("CI build number", CustomUserData.sysProperty("build.number"));
            }
            if (CustomUserData.sysPropertyPresent("agent.name")) {
                String agentNameLabel = "CI agent";
                String agentName = CustomUserData.sysProperty("agent.name");
                buildScan.value(agentNameLabel, agentName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI agent build scans", (Map<String, String>)ImmutableMap.of((Object)agentNameLabel, (Object)agentName));
            }
        }
        if (CustomUserData.isCircleCI()) {
            if (CustomUserData.envVariablePresent("CIRCLE_BUILD_URL")) {
                buildScan.link("CircleCI build", CustomUserData.envVariable("CIRCLE_BUILD_URL"));
            }
            if (CustomUserData.envVariablePresent("CIRCLE_BUILD_NUM")) {
                buildScan.value("CI build number", CustomUserData.envVariable("CIRCLE_BUILD_NUM"));
            }
            if (CustomUserData.envVariablePresent("CIRCLE_JOB")) {
                jobNameLabel = "CI job";
                jobName = CustomUserData.envVariable("CIRCLE_JOB");
                buildScan.value(jobNameLabel, jobName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI job build scans", (Map<String, String>)ImmutableMap.of((Object)jobNameLabel, (Object)jobName));
            }
            if (CustomUserData.envVariablePresent("CIRCLE_WORKFLOW_ID")) {
                String workflowIdLabel = "CI workflow";
                String workflowId = CustomUserData.envVariable("CIRCLE_WORKFLOW_ID");
                buildScan.value(workflowIdLabel, workflowId);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI workflow build scans", (Map<String, String>)ImmutableMap.of((Object)workflowIdLabel, (Object)workflowId));
            }
        }
        if (CustomUserData.isBamboo()) {
            if (CustomUserData.envVariablePresent("bamboo_resultsUrl")) {
                buildScan.link("Bamboo build", CustomUserData.envVariable("bamboo_resultsUrl"));
            }
            if (CustomUserData.envVariablePresent("bamboo_buildNumber")) {
                buildScan.value("CI build number", CustomUserData.envVariable("bamboo_buildNumber"));
            }
            if (CustomUserData.envVariablePresent("bamboo_planName")) {
                String planNameLabel = "CI plan";
                String planName = CustomUserData.envVariable("bamboo_planName");
                buildScan.value(planNameLabel, planName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI plan build scans", (Map<String, String>)ImmutableMap.of((Object)planNameLabel, (Object)planName));
            }
            if (CustomUserData.envVariablePresent("bamboo_buildPlanName")) {
                String buildPlanNameLabel = "CI build plan";
                String buildPlanName = CustomUserData.envVariable("bamboo_buildPlanName");
                buildScan.value(buildPlanNameLabel, buildPlanName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI build plan build scans", (Map<String, String>)ImmutableMap.of((Object)buildPlanNameLabel, (Object)buildPlanName));
            }
            if (CustomUserData.envVariablePresent("bamboo_agentId")) {
                String agentIdLabel = "CI agent";
                String agentId = CustomUserData.envVariable("bamboo_agentId");
                buildScan.value(agentIdLabel, agentId);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI agent build scans", (Map<String, String>)ImmutableMap.of((Object)agentIdLabel, (Object)agentId));
            }
        }
        if (CustomUserData.isGitHubActions()) {
            if (CustomUserData.envVariablePresent("GITHUB_REPOSITORY") && CustomUserData.envVariablePresent("GITHUB_RUN_ID")) {
                buildScan.link("GitHub Actions build", "https://github.com/" + CustomUserData.envVariable("GITHUB_REPOSITORY") + "/actions/runs/" + CustomUserData.envVariable("GITHUB_RUN_ID"));
            }
            if (CustomUserData.envVariablePresent("GITHUB_WORKFLOW")) {
                String workflowNameLabel = "GitHub workflow";
                String workflowName = CustomUserData.envVariable("GITHUB_WORKFLOW");
                buildScan.value(workflowNameLabel, workflowName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "GitHub workflow build scans", (Map<String, String>)ImmutableMap.of((Object)workflowNameLabel, (Object)workflowName));
            }
        }
        if (CustomUserData.isGitLab()) {
            if (CustomUserData.envVariablePresent("CI_JOB_URL")) {
                buildScan.link("GitLab build", CustomUserData.envVariable("CI_JOB_URL"));
            }
            if (CustomUserData.envVariablePresent("CI_PIPELINE_URL")) {
                buildScan.link("GitLab pipeline", CustomUserData.envVariable("CI_PIPELINE_URL"));
            }
            if (CustomUserData.envVariablePresent("CI_JOB_NAME")) {
                jobNameLabel = "CI job";
                jobName = CustomUserData.envVariable("CI_JOB_NAME");
                buildScan.value(jobNameLabel, jobName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI job build scans", (Map<String, String>)ImmutableMap.of((Object)jobNameLabel, (Object)jobName));
            }
            if (CustomUserData.envVariablePresent("CI_JOB_STAGE")) {
                stageNameLabel = "CI stage";
                stageName = CustomUserData.envVariable("CI_JOB_STAGE");
                buildScan.value(stageNameLabel, stageName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "CI stage build scans", (Map<String, String>)ImmutableMap.of((Object)stageNameLabel, (Object)stageName));
            }
        }
        if (CustomUserData.isTravis()) {
            if (CustomUserData.envVariablePresent("TRAVIS_BUILD_WEB_URL")) {
                buildScan.link("TRAVIS build", CustomUserData.envVariable("TRAVIS_BUILD_WEB_URL"));
            }
            if (CustomUserData.envVariablePresent("TRAVIS_BUILD_NUMBER")) {
                buildScan.value("TRAVIS build number", CustomUserData.envVariable("TRAVIS_BUILD_NUMBER"));
            }
            if (CustomUserData.envVariablePresent("TRAVIS_EVENT_TYPE")) {
                buildScan.tag(CustomUserData.envVariable("TRAVIS_EVENT_TYPE"));
            }
            if (CustomUserData.envVariablePresent("TRAVIS_TAG")) {
                buildScan.value("TRAVIS tag", CustomUserData.envVariable("TRAVIS_TAG"));
            }
            if (CustomUserData.envVariablePresent("TRAVIS_JOB_NAME")) {
                jobNameLabel = "TRAVIS job";
                jobName = CustomUserData.envVariable("TRAVIS_JOB_NAME");
                buildScan.value(jobNameLabel, jobName);
                CustomUserData.addCustomLinkWithSearchTerms(buildScan, "TRAVIS job build scans", (Map<String, String>)ImmutableMap.of((Object)jobNameLabel, (Object)jobName));
            }
        }
    }

    static void addGitMetadata(BuildScanApi buildScan) {
        buildScan.background(api -> {
            if (!CustomUserData.isGitInstalled()) {
                return;
            }
            String gitCommitId = CustomUserData.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
            String gitBranchName = CustomUserData.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD");
            String gitStatus = CustomUserData.execAndGetStdOut("git", "status", "--porcelain");
            if (gitCommitId != null) {
                String gitCommitIdLabel = "Git commit id";
                api.value(gitCommitIdLabel, gitCommitId);
                CustomUserData.addCustomLinkWithSearchTerms(api, "Git commit id build scans", (Map<String, String>)ImmutableMap.of((Object)gitCommitIdLabel, (Object)gitCommitId));
                String originUrl = CustomUserData.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
                if (!Strings.isNullOrEmpty((String)originUrl)) {
                    Matcher matcher;
                    if (originUrl.contains("github.com/") || originUrl.contains("github.com:")) {
                        Matcher matcher2 = Pattern.compile("(.*)github\\.com[/|:](.*)").matcher(originUrl);
                        if (matcher2.matches()) {
                            String rawRepoPath = matcher2.group(2);
                            String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                            api.link("Github source", "https://github.com/" + repoPath + "/tree/" + gitCommitId);
                        }
                    } else if ((originUrl.contains("gitlab.com/") || originUrl.contains("gitlab.com:")) && (matcher = Pattern.compile("(.*)gitlab\\.com[/|:](.*)").matcher(originUrl)).matches()) {
                        String rawRepoPath = matcher.group(2);
                        String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                        api.link("GitLab Source", "https://gitlab.com/" + repoPath + "/-/commit/" + gitCommitId);
                    }
                }
            }
            if (gitBranchName != null) {
                api.tag(gitBranchName);
                api.value("Git branch", gitBranchName);
            }
            if (gitStatus != null) {
                api.tag("Dirty");
                api.value("Git status", gitStatus);
            }
        });
    }

    private static boolean isCi() {
        return CustomUserData.isJenkins() || CustomUserData.isTeamCity() || CustomUserData.isCircleCI() || CustomUserData.isBamboo() || CustomUserData.isGitHubActions() || CustomUserData.isGitLab() || CustomUserData.isTravis();
    }

    private static boolean isJenkins() {
        return CustomUserData.envVariablePresent("JENKINS_URL");
    }

    private static boolean isTeamCity() {
        return CustomUserData.envVariablePresent("TEAMCITY_VERSION");
    }

    private static boolean isCircleCI() {
        return CustomUserData.envVariablePresent("CIRCLE_BUILD_URL");
    }

    private static boolean isBamboo() {
        return CustomUserData.envVariablePresent("bamboo_resultsUrl");
    }

    private static boolean isGitHubActions() {
        return CustomUserData.envVariablePresent("GITHUB_ACTIONS");
    }

    private static boolean isGitLab() {
        return CustomUserData.envVariablePresent("GITLAB_CI");
    }

    private static boolean isTravis() {
        return CustomUserData.envVariablePresent("TRAVIS_JOB_ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isGitInstalled() {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(new String[]{"git", "--version"});
            boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
            boolean bl = finished && process.exitValue() == 0;
            return bl;
        }
        catch (IOException | InterruptedException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String execAndGetStdOut(String ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void addCustomLinkWithSearchTerms(BuildScanApi buildScan, String title, Map<String, String> search) {
        String server = buildScan.getServer();
        if (server != null) {
            String searchParams = CustomUserData.customValueSearchParams(search);
            String url = CustomUserData.appendIfMissing(server, "/") + "scans?" + searchParams + "#selection.buildScanB=" + CustomUserData.urlEncode("{SCAN_ID}");
            buildScan.link(title, url);
        }
    }

    private static String customValueSearchParams(Map<String, String> search) {
        return search.entrySet().stream().map(e -> "search.names=" + CustomUserData.urlEncode((String)e.getKey()) + "&search.values=" + CustomUserData.urlEncode((String)e.getValue())).collect(Collectors.joining("&"));
    }

    private static String sysProperty(String name) {
        return System.getProperty(name);
    }

    private static boolean sysPropertyPresent(String name) {
        return !Strings.isNullOrEmpty((String)CustomUserData.sysProperty(name));
    }

    private static boolean sysPropertyKeyStartingWith(String keyPrefix) {
        for (Object key : System.getProperties().keySet()) {
            String stringKey;
            if (!(key instanceof String) || !(stringKey = (String)key).startsWith(keyPrefix)) continue;
            return true;
        }
        return false;
    }

    private static String envVariable(String name) {
        return System.getenv(name);
    }

    private static boolean envVariablePresent(String name) {
        return !Strings.isNullOrEmpty((String)CustomUserData.envVariable(name));
    }

    private static String appendIfMissing(String str, String suffix) {
        return str.endsWith(suffix) ? str : str + suffix;
    }

    private static String trimAtEnd(String str) {
        return ('x' + str).trim().substring(1);
    }

    private static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties readPropertiesFile(String name) {
        try (FileInputStream input = new FileInputStream(name);){
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CustomUserData() {
    }
}

