/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.maven.extension.api.cache.BuildCacheApi;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.monitor.logging.DefaultLog;
import org.codehaus.plexus.logging.Logger;

final class GroovyScriptUserData {
    static void addToApis(MavenSession session, @Nullable BuildScanApi buildScan, @Nullable BuildCacheApi buildCache, Logger logger) throws MavenExecutionException {
        File scriptFile = GroovyScriptUserData.getScriptFile(session);
        if (scriptFile.exists()) {
            logger.debug("Evaluating custom user data Groovy script: " + scriptFile);
            GroovyScriptUserData.evaluateGroovyScript(session, buildScan, buildCache, logger, scriptFile);
        } else {
            logger.debug("Skipping evaluation of custom user data Groovy script because it does not exist: " + scriptFile);
        }
    }

    private static File getScriptFile(MavenSession session) {
        File rootDir = session.getRequest().getMultiModuleProjectDirectory();
        return new File(rootDir, ".mvn/gradle-enterprise-custom-user-data.groovy");
    }

    private static void evaluateGroovyScript(MavenSession session, @Nullable BuildScanApi buildScan, @Nullable BuildCacheApi buildCache, Logger logger, File scriptFile) throws MavenExecutionException {
        try {
            Binding binding = GroovyScriptUserData.prepareBinding(session, buildScan, buildCache, logger);
            new GroovyShell(GroovyScriptUserData.class.getClassLoader(), binding).evaluate(scriptFile);
        }
        catch (Exception e) {
            throw new MavenExecutionException("Failed to evaluate custom user data Groovy script: " + scriptFile, (Throwable)e);
        }
    }

    private static Binding prepareBinding(MavenSession session, @Nullable BuildScanApi buildScan, @Nullable BuildCacheApi buildCache, Logger logger) {
        Binding binding = new Binding();
        binding.setVariable("project", (Object)session.getTopLevelProject());
        binding.setVariable("session", (Object)session);
        binding.setVariable("buildScan", (Object)buildScan);
        binding.setVariable("buildCache", (Object)buildCache);
        binding.setVariable("log", (Object)new DefaultLog(logger));
        return binding;
    }

    private GroovyScriptUserData() {
    }
}

