/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CustomBuildScanConfig {
    static void configureBuildScan(BuildScanApi buildScan) {
        CustomBuildScanConfig.captureOs(buildScan);
        CustomBuildScanConfig.captureIde(buildScan);
        CustomBuildScanConfig.captureCiOrLocal(buildScan);
        CustomBuildScanConfig.captureCiMetadata(buildScan);
        CustomBuildScanConfig.captureGitMetadata(buildScan);
    }

    private static void captureOs(BuildScanApi buildScan) {
        buildScan.tag(Utils.sysProperty("os.name"));
    }

    private static void captureIde(BuildScanApi buildScan) {
        if (Utils.sysPropertyPresent("idea.version") || Utils.sysPropertyKeyStartingWith("idea.version")) {
            buildScan.tag("IntelliJ IDEA");
        } else if (Utils.sysPropertyPresent("eclipse.buildId")) {
            buildScan.tag("Eclipse");
        } else if (!CustomBuildScanConfig.isCi()) {
            buildScan.tag("Cmd Line");
        }
    }

    private static void captureCiOrLocal(BuildScanApi buildScan) {
        buildScan.tag(CustomBuildScanConfig.isCi() ? "CI" : "LOCAL");
    }

    private static void captureCiMetadata(BuildScanApi buildScan) {
        if (CustomBuildScanConfig.isJenkins()) {
            if (Utils.envVariablePresent("BUILD_URL")) {
                buildScan.link("Jenkins build", Utils.envVariable("BUILD_URL"));
            }
            if (Utils.envVariablePresent("BUILD_NUMBER")) {
                buildScan.value("CI build number", Utils.envVariable("BUILD_NUMBER"));
            }
            if (Utils.envVariablePresent("NODE_NAME")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI node", Utils.envVariable("NODE_NAME"));
            }
            if (Utils.envVariablePresent("JOB_NAME")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI job", Utils.envVariable("JOB_NAME"));
            }
            if (Utils.envVariablePresent("STAGE_NAME")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI stage", Utils.envVariable("STAGE_NAME"));
            }
        }
        if (CustomBuildScanConfig.isTeamCity()) {
            Properties properties;
            String teamCityServerUrl;
            if (Utils.sysPropertyPresent("teamcity.configuration.properties.file") && (teamCityServerUrl = (properties = Utils.readPropertiesFile(Utils.sysProperty("teamcity.configuration.properties.file"))).getProperty("teamcity.serverUrl")) != null && Utils.sysPropertyPresent("build.number") && Utils.sysPropertyPresent("teamcity.buildType.id")) {
                String buildNumber = Utils.sysProperty("build.number");
                String buildTypeId = Utils.sysProperty("teamcity.buildType.id");
                buildScan.link("TeamCity build", Utils.appendIfMissing(teamCityServerUrl, "/") + "viewLog.html?buildNumber=" + buildNumber + "&buildTypeId=" + buildTypeId);
            }
            if (Utils.sysPropertyPresent("build.number")) {
                buildScan.value("CI build number", Utils.sysProperty("build.number"));
            }
            if (Utils.sysPropertyPresent("agent.name")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI agent", Utils.sysProperty("agent.name"));
            }
        }
        if (CustomBuildScanConfig.isCircleCI()) {
            if (Utils.envVariablePresent("CIRCLE_BUILD_URL")) {
                buildScan.link("CircleCI build", Utils.envVariable("CIRCLE_BUILD_URL"));
            }
            if (Utils.envVariablePresent("CIRCLE_BUILD_NUM")) {
                buildScan.value("CI build number", Utils.envVariable("CIRCLE_BUILD_NUM"));
            }
            if (Utils.envVariablePresent("CIRCLE_JOB")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI job", Utils.envVariable("CIRCLE_JOB"));
            }
            if (Utils.envVariablePresent("CIRCLE_WORKFLOW_ID")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI workflow", Utils.envVariable("CIRCLE_WORKFLOW_ID"));
            }
        }
        if (CustomBuildScanConfig.isBamboo()) {
            if (Utils.envVariablePresent("bamboo_resultsUrl")) {
                buildScan.link("Bamboo build", Utils.envVariable("bamboo_resultsUrl"));
            }
            if (Utils.envVariablePresent("bamboo_buildNumber")) {
                buildScan.value("CI build number", Utils.envVariable("bamboo_buildNumber"));
            }
            if (Utils.envVariablePresent("bamboo_planName")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI plan", Utils.envVariable("bamboo_planName"));
            }
            if (Utils.envVariablePresent("bamboo_buildPlanName")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI build plan", Utils.envVariable("bamboo_buildPlanName"));
            }
            if (Utils.envVariablePresent("bamboo_agentId")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI agent", Utils.envVariable("bamboo_agentId"));
            }
        }
        if (CustomBuildScanConfig.isGitHubActions()) {
            if (Utils.envVariablePresent("GITHUB_REPOSITORY") && Utils.envVariablePresent("GITHUB_RUN_ID")) {
                buildScan.link("GitHub Actions build", "https://github.com/" + Utils.envVariable("GITHUB_REPOSITORY") + "/actions/runs/" + Utils.envVariable("GITHUB_RUN_ID"));
            }
            if (Utils.envVariablePresent("GITHUB_WORKFLOW")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "GitHub workflow", Utils.envVariable("GITHUB_WORKFLOW"));
            }
        }
        if (CustomBuildScanConfig.isGitLab()) {
            if (Utils.envVariablePresent("CI_JOB_URL")) {
                buildScan.link("GitLab build", Utils.envVariable("CI_JOB_URL"));
            }
            if (Utils.envVariablePresent("CI_PIPELINE_URL")) {
                buildScan.link("GitLab pipeline", Utils.envVariable("CI_PIPELINE_URL"));
            }
            if (Utils.envVariablePresent("CI_JOB_NAME")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI job", Utils.envVariable("CI_JOB_NAME"));
            }
            if (Utils.envVariablePresent("CI_JOB_STAGE")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI stage", Utils.envVariable("CI_JOB_STAGE"));
            }
        }
        if (CustomBuildScanConfig.isTravis()) {
            if (Utils.envVariablePresent("TRAVIS_BUILD_WEB_URL")) {
                buildScan.link("Travis build", Utils.envVariable("TRAVIS_BUILD_WEB_URL"));
            }
            if (Utils.envVariablePresent("TRAVIS_BUILD_NUMBER")) {
                buildScan.value("CI build number", Utils.envVariable("TRAVIS_BUILD_NUMBER"));
            }
            if (Utils.envVariablePresent("TRAVIS_JOB_NAME")) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(buildScan, "CI job", Utils.envVariable("TRAVIS_JOB_NAME"));
            }
            if (Utils.envVariablePresent("TRAVIS_EVENT_TYPE")) {
                buildScan.tag(Utils.envVariable("TRAVIS_EVENT_TYPE"));
            }
        }
    }

    private static boolean isCi() {
        return CustomBuildScanConfig.isJenkins() || CustomBuildScanConfig.isTeamCity() || CustomBuildScanConfig.isCircleCI() || CustomBuildScanConfig.isBamboo() || CustomBuildScanConfig.isGitHubActions() || CustomBuildScanConfig.isGitLab() || CustomBuildScanConfig.isTravis();
    }

    private static boolean isJenkins() {
        return Utils.envVariablePresent("JENKINS_URL");
    }

    private static boolean isTeamCity() {
        return Utils.envVariablePresent("TEAMCITY_VERSION");
    }

    private static boolean isCircleCI() {
        return Utils.envVariablePresent("CIRCLE_BUILD_URL");
    }

    private static boolean isBamboo() {
        return Utils.envVariablePresent("bamboo_resultsUrl");
    }

    private static boolean isGitHubActions() {
        return Utils.envVariablePresent("GITHUB_ACTIONS");
    }

    private static boolean isGitLab() {
        return Utils.envVariablePresent("GITLAB_CI");
    }

    private static boolean isTravis() {
        return Utils.envVariablePresent("TRAVIS_JOB_ID");
    }

    static void captureGitMetadata(BuildScanApi buildScan) {
        buildScan.background(api -> {
            if (!CustomBuildScanConfig.isGitInstalled()) {
                return;
            }
            String gitCommitId = Utils.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
            String gitBranchName = Utils.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD");
            String gitStatus = Utils.execAndGetStdOut("git", "status", "--porcelain");
            if (gitCommitId != null) {
                CustomBuildScanConfig.addCustomValueAndSearchLink(api, "Git commit id", gitCommitId);
                String originUrl = Utils.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
                if (Utils.isNotEmpty(originUrl)) {
                    Matcher matcher;
                    if (originUrl.contains("github.com/") || originUrl.contains("github.com:")) {
                        Matcher matcher2 = Pattern.compile("(.*)github\\.com[/|:](.*)").matcher(originUrl);
                        if (matcher2.matches()) {
                            String rawRepoPath = matcher2.group(2);
                            String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                            api.link("Github source", "https://github.com/" + repoPath + "/tree/" + gitCommitId);
                        }
                    } else if ((originUrl.contains("gitlab.com/") || originUrl.contains("gitlab.com:")) && (matcher = Pattern.compile("(.*)gitlab\\.com[/|:](.*)").matcher(originUrl)).matches()) {
                        String rawRepoPath = matcher.group(2);
                        String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                        api.link("GitLab Source", "https://gitlab.com/" + repoPath + "/-/commit/" + gitCommitId);
                    }
                }
            }
            if (Utils.isNotEmpty(gitBranchName)) {
                api.tag(gitBranchName);
                api.value("Git branch", gitBranchName);
            }
            if (Utils.isNotEmpty(gitStatus)) {
                api.tag("Dirty");
                api.value("Git status", gitStatus);
            }
        });
    }

    private static boolean isGitInstalled() {
        return Utils.execAndCheckSuccess("git", "--version");
    }

    private static void addCustomValueAndSearchLink(BuildScanApi buildScan, String label, String value) {
        buildScan.value(label, value);
        CustomBuildScanConfig.addCustomLinkWithSearchTerms(buildScan, label + " build scans", label, value);
    }

    private static void addCustomLinkWithSearchTerms(BuildScanApi buildScan, String title, String name, String value) {
        String server = buildScan.getServer();
        if (server != null) {
            String searchParams = "search.names=" + Utils.urlEncode(name) + "&search.values=" + Utils.urlEncode(value);
            String url = Utils.appendIfMissing(server, "/") + "scans?" + searchParams + "#selection.buildScanB=" + Utils.urlEncode("{SCAN_ID}");
            buildScan.link(title, url);
        }
    }

    private CustomBuildScanConfig() {
    }
}

