/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.MavenSession;

final class Utils {
    static Optional<String> envVariable(String name) {
        return Optional.ofNullable(System.getenv(name));
    }

    static Optional<String> projectProperty(MavenSession mavenSession, String name) {
        String value = mavenSession.getSystemProperties().getProperty(name);
        return Optional.ofNullable(value);
    }

    static Optional<String> sysProperty(String name) {
        return Optional.ofNullable(System.getProperty(name));
    }

    static Optional<Boolean> booleanSysProperty(String name) {
        return Utils.sysProperty(name).map(Boolean::parseBoolean);
    }

    static Optional<Duration> durationSysProperty(String name) {
        return Utils.sysProperty(name).map(Duration::parse);
    }

    static boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    static String stripPrefix(String prefix, String string) {
        return string.startsWith(prefix) ? string.substring(prefix.length()) : string;
    }

    static String appendIfMissing(String str, String suffix) {
        return str.endsWith(suffix) ? str : str + suffix;
    }

    static URI appendPathAndTrailingSlash(URI baseUri, String path) {
        if (Utils.isNotEmpty(path)) {
            String normalizedBasePath = Utils.appendIfMissing(baseUri.getPath(), "/");
            String normalizedPath = Utils.appendIfMissing(Utils.stripPrefix("/", path), "/");
            return baseUri.resolve(normalizedBasePath).resolve(normalizedPath);
        }
        return baseUri;
    }

    static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static String redactUserInfo(String url) {
        try {
            String userInfo = new URI(url).getUserInfo();
            return userInfo == null ? url : url.replace(userInfo + '@', "******@");
        }
        catch (URISyntaxException e) {
            return url;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties readPropertiesFile(String name) {
        try (FileInputStream input = new FileInputStream(name);){
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean execAndCheckSuccess(String ... args) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(args);
            boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
            boolean bl = finished && process.exitValue() == 0;
            return bl;
        }
        catch (IOException | InterruptedException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    /*
     * Exception decompiling
     */
    static String execAndGetStdOut(String ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readFully(Reader reader) throws IOException {
        int nRead;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((nRead = reader.read(buf)) != -1) {
            sb.append(buf, 0, nRead);
        }
        return sb.toString();
    }

    private static String trimAtEnd(String str) {
        return ('x' + str).trim().substring(1);
    }

    private Utils() {
    }
}

