/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;

final class CustomBuildScanEnhancements {
    private final BuildScanApi buildScan;
    private final MavenSession mavenSession;

    CustomBuildScanEnhancements(BuildScanApi buildScan, MavenSession mavenSession) {
        this.buildScan = buildScan;
        this.mavenSession = mavenSession;
    }

    void apply() {
        this.captureOs();
        this.captureIde();
        this.captureCiOrLocal();
        this.captureCiMetadata();
        this.captureGitMetadata();
        this.captureSkipTestsFlags();
    }

    private void captureOs() {
        Utils.sysProperty("os.name").ifPresent(arg_0 -> ((BuildScanApi)this.buildScan).tag(arg_0));
    }

    private void captureIde() {
        if (!this.isCi()) {
            Optional<String> ideaVersion = Utils.sysProperty("idea.version");
            Optional<String> eclipseVersion = Utils.sysProperty("eclipse.buildId");
            if (ideaVersion.isPresent()) {
                this.buildScan.tag("IntelliJ IDEA");
                this.buildScan.value("IntelliJ IDEA version", ideaVersion.get());
            } else if (eclipseVersion.isPresent()) {
                this.buildScan.tag("Eclipse");
                this.buildScan.value("Eclipse version", eclipseVersion.get());
            } else {
                this.buildScan.tag("Cmd Line");
            }
        }
    }

    private void captureCiOrLocal() {
        this.buildScan.tag(this.isCi() ? "CI" : "LOCAL");
    }

    private void captureCiMetadata() {
        if (this.isJenkins() || this.isHudson()) {
            Utils.envVariable("BUILD_URL").ifPresent(url -> this.buildScan.link(this.isJenkins() ? "Jenkins build" : "Hudson build", url));
            Utils.envVariable("BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
            Utils.envVariable("NODE_NAME").ifPresent(value -> this.addCustomValueAndSearchLink("CI node", (String)value));
            Utils.envVariable("JOB_NAME").ifPresent(value -> this.addCustomValueAndSearchLink("CI job", (String)value));
            Utils.envVariable("STAGE_NAME").ifPresent(value -> this.addCustomValueAndSearchLink("CI stage", (String)value));
        }
        if (this.isTeamCity()) {
            Properties properties;
            String teamCityServerUrl;
            Optional<String> teamCityConfigFile = this.projectProperty("teamcity.configuration.properties.file");
            Optional<String> buildNumber = this.projectProperty("build.number");
            Optional<String> buildTypeId = this.projectProperty("teamcity.buildType.id");
            if (teamCityConfigFile.isPresent() && buildNumber.isPresent() && buildTypeId.isPresent() && (teamCityServerUrl = (properties = Utils.readPropertiesFile(teamCityConfigFile.get())).getProperty("teamcity.serverUrl")) != null) {
                String buildUrl = Utils.appendIfMissing(teamCityServerUrl, "/") + "viewLog.html?buildNumber=" + Utils.urlEncode(buildNumber.get()) + "&buildTypeId=" + Utils.urlEncode(buildTypeId.get());
                this.buildScan.link("TeamCity build", buildUrl);
            }
            buildNumber.ifPresent(value -> this.buildScan.value("CI build number", value));
            buildTypeId.ifPresent(value -> this.addCustomValueAndSearchLink("CI build config", (String)value));
            this.projectProperty("agent.name").ifPresent(value -> this.addCustomValueAndSearchLink("CI agent", (String)value));
        }
        if (this.isCircleCI()) {
            Utils.envVariable("CIRCLE_BUILD_URL").ifPresent(url -> this.buildScan.link("CircleCI build", url));
            Utils.envVariable("CIRCLE_BUILD_NUM").ifPresent(value -> this.buildScan.value("CI build number", value));
            Utils.envVariable("CIRCLE_JOB").ifPresent(value -> this.addCustomValueAndSearchLink("CI job", (String)value));
            Utils.envVariable("CIRCLE_WORKFLOW_ID").ifPresent(value -> this.addCustomValueAndSearchLink("CI workflow", (String)value));
        }
        if (this.isBamboo()) {
            Utils.envVariable("bamboo_resultsUrl").ifPresent(url -> this.buildScan.link("Bamboo build", url));
            Utils.envVariable("bamboo_buildNumber").ifPresent(value -> this.buildScan.value("CI build number", value));
            Utils.envVariable("bamboo_planName").ifPresent(value -> this.addCustomValueAndSearchLink("CI plan", (String)value));
            Utils.envVariable("bamboo_buildPlanName").ifPresent(value -> this.addCustomValueAndSearchLink("CI build plan", (String)value));
            Utils.envVariable("bamboo_agentId").ifPresent(value -> this.addCustomValueAndSearchLink("CI agent", (String)value));
        }
        if (this.isGitHubActions()) {
            Optional<String> gitHubRepository = Utils.envVariable("GITHUB_REPOSITORY");
            Optional<String> gitHubRunId = Utils.envVariable("GITHUB_RUN_ID");
            if (gitHubRepository.isPresent() && gitHubRunId.isPresent()) {
                this.buildScan.link("GitHub Actions build", "https://github.com/" + gitHubRepository.get() + "/actions/runs/" + gitHubRunId.get());
            }
            Utils.envVariable("GITHUB_WORKFLOW").ifPresent(value -> this.addCustomValueAndSearchLink("CI workflow", (String)value));
            Utils.envVariable("GITHUB_RUN_ID").ifPresent(value -> this.addCustomValueAndSearchLink("CI run", (String)value));
        }
        if (this.isGitLab()) {
            Utils.envVariable("CI_JOB_URL").ifPresent(url -> this.buildScan.link("GitLab build", url));
            Utils.envVariable("CI_PIPELINE_URL").ifPresent(url -> this.buildScan.link("GitLab pipeline", url));
            Utils.envVariable("CI_JOB_NAME").ifPresent(value1 -> this.addCustomValueAndSearchLink("CI job", (String)value1));
            Utils.envVariable("CI_JOB_STAGE").ifPresent(value -> this.addCustomValueAndSearchLink("CI stage", (String)value));
        }
        if (this.isTravis()) {
            Utils.envVariable("TRAVIS_BUILD_WEB_URL").ifPresent(url -> this.buildScan.link("Travis build", url));
            Utils.envVariable("TRAVIS_BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
            Utils.envVariable("TRAVIS_JOB_NAME").ifPresent(value -> this.addCustomValueAndSearchLink("CI job", (String)value));
            Utils.envVariable("TRAVIS_EVENT_TYPE").ifPresent(arg_0 -> ((BuildScanApi)this.buildScan).tag(arg_0));
        }
        if (this.isBitrise()) {
            Utils.envVariable("BITRISE_BUILD_URL").ifPresent(url -> this.buildScan.link("Bitrise build", url));
            Utils.envVariable("BITRISE_BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
        }
        if (this.isGoCD()) {
            Optional<String> goServerUrl;
            Optional<String> jobName;
            Optional<String> stageNumber;
            Optional<String> stageName;
            Optional<String> pipelineNumber;
            Optional<String> pipelineName = Utils.envVariable("GO_PIPELINE_NAME");
            if (Stream.of(pipelineName, pipelineNumber = Utils.envVariable("GO_PIPELINE_COUNTER"), stageName = Utils.envVariable("GO_STAGE_NAME"), stageNumber = Utils.envVariable("GO_STAGE_COUNTER"), jobName = Utils.envVariable("GO_JOB_NAME"), goServerUrl = Utils.envVariable("GO_SERVER_URL")).allMatch(Optional::isPresent)) {
                String buildUrl = String.format("%s/tab/build/detail/%s/%s/%s/%s/%s", goServerUrl.get(), pipelineName.get(), pipelineNumber.get(), stageName.get(), stageNumber.get(), jobName.get());
                this.buildScan.link("GoCD build", buildUrl);
            } else if (goServerUrl.isPresent()) {
                this.buildScan.link("GoCD", goServerUrl.get());
            }
            pipelineName.ifPresent(value -> this.addCustomValueAndSearchLink("CI pipeline", (String)value));
            jobName.ifPresent(value -> this.addCustomValueAndSearchLink("CI job", (String)value));
            stageName.ifPresent(value -> this.addCustomValueAndSearchLink("CI stage", (String)value));
        }
        if (this.isAzurePipelines()) {
            Optional<String> buildId;
            Optional<String> azureProject;
            Optional<String> azureServerUrl = Utils.envVariable("SYSTEM_TEAMFOUNDATIONCOLLECTIONURI");
            if (Stream.of(azureServerUrl, azureProject = Utils.envVariable("SYSTEM_TEAMPROJECT"), buildId = Utils.envVariable("BUILD_BUILDID")).allMatch(Optional::isPresent)) {
                String buildUrl = String.format("%s%s/_build/results?buildId=%s", azureServerUrl.get(), azureProject.get(), buildId.get());
                this.buildScan.link("Azure Pipelines build", buildUrl);
            } else if (azureServerUrl.isPresent()) {
                this.buildScan.link("Azure Pipelines", azureServerUrl.get());
            }
            buildId.ifPresent(value -> this.buildScan.value("CI build number", value));
        }
    }

    private boolean isCi() {
        return this.isGenericCI() || this.isJenkins() || this.isHudson() || this.isTeamCity() || this.isCircleCI() || this.isBamboo() || this.isGitHubActions() || this.isGitLab() || this.isTravis() || this.isBitrise() || this.isGoCD() || this.isAzurePipelines();
    }

    private boolean isGenericCI() {
        return Utils.envVariable("CI").isPresent() || Utils.sysProperty("CI").isPresent();
    }

    private boolean isJenkins() {
        return Utils.envVariable("JENKINS_URL").isPresent();
    }

    private boolean isHudson() {
        return Utils.envVariable("HUDSON_URL").isPresent();
    }

    private boolean isTeamCity() {
        return Utils.envVariable("TEAMCITY_VERSION").isPresent();
    }

    private boolean isCircleCI() {
        return Utils.envVariable("CIRCLE_BUILD_URL").isPresent();
    }

    private boolean isBamboo() {
        return Utils.envVariable("bamboo_resultsUrl").isPresent();
    }

    private boolean isGitHubActions() {
        return Utils.envVariable("GITHUB_ACTIONS").isPresent();
    }

    private boolean isGitLab() {
        return Utils.envVariable("GITLAB_CI").isPresent();
    }

    private boolean isTravis() {
        return Utils.envVariable("TRAVIS_JOB_ID").isPresent();
    }

    private boolean isBitrise() {
        return Utils.envVariable("BITRISE_BUILD_URL").isPresent();
    }

    private boolean isGoCD() {
        return Utils.envVariable("GO_SERVER_URL").isPresent();
    }

    private boolean isAzurePipelines() {
        return Utils.envVariable("TF_BUILD").isPresent();
    }

    private void captureGitMetadata() {
        this.buildScan.background((Consumer)new CaptureGitMetadataAction());
    }

    private void captureSkipTestsFlags() {
        this.addCustomValueWhenProjectPropertyResolvesToTrue("skipITs");
        this.addCustomValueWhenProjectPropertyResolvesToTrue("skipTests");
        this.addCustomValueWhenProjectPropertyResolvesToTrue("maven.test.skip");
    }

    private void addCustomValueWhenProjectPropertyResolvesToTrue(String property) {
        this.projectProperty(property).ifPresent(value -> {
            if (value.isEmpty() || Boolean.valueOf(value).equals(Boolean.TRUE)) {
                this.buildScan.value("switches." + property, "On");
            }
        });
    }

    private void addCustomValueAndSearchLink(String name, String value) {
        CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, name, name, value);
    }

    private static void addCustomValueAndSearchLink(BuildScanApi buildScan, String linkLabel, String name, String value) {
        buildScan.value(name, value);
        buildScan.buildFinished(result -> CustomBuildScanEnhancements.addSearchLinkForCustomValue(buildScan, linkLabel, name, value));
    }

    private static void addSearchLinkForCustomValue(BuildScanApi buildScan, String linkLabel, String name, String value) {
        String server = buildScan.getServer();
        if (server != null) {
            String searchParams = "search.names=" + Utils.urlEncode(name) + "&search.values=" + Utils.urlEncode(value);
            String url = Utils.appendIfMissing(server, "/") + "scans?" + searchParams + "#selection.buildScanB=" + Utils.urlEncode("{SCAN_ID}");
            buildScan.link(linkLabel + " build scans", url);
        }
    }

    private Optional<String> projectProperty(String name) {
        return Utils.projectProperty(this.mavenSession, name);
    }

    private static final class CaptureGitMetadataAction
    implements Consumer<BuildScanApi> {
        private CaptureGitMetadataAction() {
        }

        @Override
        public void accept(BuildScanApi buildScan) {
            if (!this.isGitInstalled()) {
                return;
            }
            String gitRepo = Utils.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
            String gitCommitId = Utils.execAndGetStdOut("git", "rev-parse", "--verify", "HEAD");
            String gitCommitShortId = Utils.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
            String gitBranchName = this.getGitBranchName(() -> Utils.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD"));
            String gitStatus = Utils.execAndGetStdOut("git", "status", "--porcelain");
            if (Utils.isNotEmpty(gitRepo)) {
                buildScan.value("Git repository", Utils.redactUserInfo(gitRepo));
            }
            if (Utils.isNotEmpty(gitCommitId)) {
                buildScan.value("Git commit id", gitCommitId);
            }
            if (Utils.isNotEmpty(gitCommitShortId)) {
                CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "Git commit id", "Git commit id short", gitCommitShortId);
            }
            if (Utils.isNotEmpty(gitBranchName)) {
                buildScan.tag(gitBranchName);
                buildScan.value("Git branch", gitBranchName);
            }
            if (Utils.isNotEmpty(gitStatus)) {
                buildScan.tag("Dirty");
                buildScan.value("Git status", gitStatus);
            }
            if (Utils.isNotEmpty(gitRepo) && Utils.isNotEmpty(gitCommitId)) {
                Matcher matcher;
                if (gitRepo.contains("github.com/") || gitRepo.contains("github.com:")) {
                    Matcher matcher2 = Pattern.compile("(.*)github\\.com[/|:](.*)").matcher(gitRepo);
                    if (matcher2.matches()) {
                        String rawRepoPath = matcher2.group(2);
                        String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                        buildScan.link("Github source", "https://github.com/" + repoPath + "/tree/" + gitCommitId);
                    }
                } else if ((gitRepo.contains("gitlab.com/") || gitRepo.contains("gitlab.com:")) && (matcher = Pattern.compile("(.*)gitlab\\.com[/|:](.*)").matcher(gitRepo)).matches()) {
                    String rawRepoPath = matcher.group(2);
                    String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                    buildScan.link("GitLab Source", "https://gitlab.com/" + repoPath + "/-/commit/" + gitCommitId);
                }
            }
        }

        private boolean isGitInstalled() {
            return Utils.execAndCheckSuccess("git", "--version");
        }

        private String getGitBranchName(Supplier<String> gitCommand) {
            Optional<String> branch;
            if (this.isJenkins() || this.isHudson()) {
                Optional<String> branch2 = Utils.envVariable("BRANCH_NAME");
                if (branch2.isPresent()) {
                    return branch2.get();
                }
            } else if (this.isGitLab()) {
                Optional<String> branch3 = Utils.envVariable("CI_COMMIT_REF_NAME");
                if (branch3.isPresent()) {
                    return branch3.get();
                }
            } else if (this.isAzurePipelines() && (branch = Utils.envVariable("BUILD_SOURCEBRANCH")).isPresent()) {
                return branch.get();
            }
            return gitCommand.get();
        }

        private boolean isJenkins() {
            return Utils.envVariable("JENKINS_URL").isPresent();
        }

        private boolean isHudson() {
            return Utils.envVariable("HUDSON_URL").isPresent();
        }

        private boolean isGitLab() {
            return Utils.envVariable("GITLAB_CI").isPresent();
        }

        private boolean isAzurePipelines() {
            return Utils.envVariable("TF_BUILD").isPresent();
        }
    }
}

