/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.adapters.shared;

import com.gradle.develocity.agent.gradle.adapters.BuildResultAdapter;
import com.gradle.develocity.agent.gradle.adapters.BuildScanAdapter;
import com.gradle.develocity.agent.gradle.adapters.PublishedBuildScanAdapter;
import com.gradle.develocity.agent.gradle.adapters.internal.ReflectionProperty;
import com.gradle.develocity.agent.gradle.adapters.internal.ReflectionUtils;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.jetbrains.annotations.Nullable;

public abstract class ReflectingBuildScanAdapter
implements BuildScanAdapter {
    protected final Object buildScanExtension;

    public ReflectingBuildScanAdapter(Object buildScanExtension) {
        this.buildScanExtension = buildScanExtension;
    }

    @Override
    public void tag(String tag) {
        ReflectionUtils.invokeMethod(this.buildScanExtension, "tag", tag);
    }

    @Override
    public void value(String name, String value) {
        ReflectionUtils.invokeMethod(this.buildScanExtension, "value", name, value);
    }

    @Override
    public void link(String name, String url) {
        ReflectionUtils.invokeMethod(this.buildScanExtension, "link", name, url);
    }

    @Override
    public void background(final Action<? super BuildScanAdapter> action) {
        Action<Object> buildScanConfigurationAction = new Action<Object>(){

            public void execute(Object __) {
                action.execute((Object)ReflectingBuildScanAdapter.this);
            }
        };
        ReflectionUtils.invokeMethod(this.buildScanExtension, "background", buildScanConfigurationAction);
    }

    @Override
    public void buildFinished(final Action<? super BuildResultAdapter> action) {
        Action<Object> buildFinishedAction = new Action<Object>(){

            public void execute(final Object buildResult) {
                action.execute((Object)new BuildResultAdapter(){

                    @Override
                    public List<Throwable> getFailures() {
                        return ReflectingBuildScanAdapter.this.getFailuresFromBuildResult(buildResult);
                    }
                });
            }
        };
        ReflectionUtils.invokeMethod(this.buildScanExtension, "buildFinished", buildFinishedAction);
    }

    @Override
    public void buildScanPublished(final Action<? super PublishedBuildScanAdapter> action) {
        Action<Object> publishedBuildScanAction = new Action<Object>(){

            public void execute(final Object scan) {
                action.execute((Object)new PublishedBuildScanAdapter(){

                    @Override
                    public String getBuildScanId() {
                        return (String)ReflectionUtils.invokeMethod(scan, "getBuildScanId", new Object[0]);
                    }

                    @Override
                    public URI getBuildScanUri() {
                        return (URI)ReflectionUtils.invokeMethod(scan, "getBuildScanUri", new Object[0]);
                    }
                });
            }
        };
        ReflectionUtils.invokeMethod(this.buildScanExtension, "buildScanPublished", publishedBuildScanAction);
    }

    protected List<Throwable> getFailuresFromBuildResult(Object buildResult) {
        if (ReflectionUtils.isMethodSupported(buildResult, "getFailure")) {
            Throwable failure = (Throwable)ReflectionUtils.invokeMethod(buildResult, "getFailure", new Object[0]);
            return Collections.singletonList(failure);
        }
        return (List)ReflectionUtils.invokeMethod(buildResult, "getFailures", new Object[0]);
    }

    @Override
    @Nullable
    public String getTermsOfUseUrl() {
        return this.getTermsOfUseUrlProperty().get();
    }

    @Override
    public void setTermsOfUseUrl(String termsOfUseUrl) {
        this.getTermsOfUseUrlProperty().set(termsOfUseUrl);
    }

    protected abstract ReflectionProperty<String> getTermsOfUseUrlProperty();

    @Override
    @Nullable
    public String getTermsOfUseAgree() {
        return this.getTermsOfUseAgreeProperty().get();
    }

    @Override
    public void setTermsOfUseAgree(@Nullable String agree) {
        this.getTermsOfUseAgreeProperty().set(agree);
    }

    protected abstract ReflectionProperty<String> getTermsOfUseAgreeProperty();

    @Override
    public void setUploadInBackground(boolean value) {
        this.getUploadInBackgroundProperty().set(value);
    }

    @Override
    public boolean isUploadInBackground() {
        return this.getUploadInBackgroundProperty().get();
    }

    protected abstract ReflectionProperty<Boolean> getUploadInBackgroundProperty();

    @Override
    public void publishAlways() {
        ReflectionUtils.invokeMethod(this.buildScanExtension, "publishAlways", new Object[0]);
    }

    @Override
    public void publishAlwaysIf(boolean condition) {
        ReflectionUtils.invokeMethod(this.buildScanExtension, "publishAlwaysIf", condition);
    }

    @Override
    public void publishOnFailure() {
        ReflectionUtils.invokeMethod(this.buildScanExtension, "publishOnFailure", new Object[0]);
    }

    @Override
    public void publishOnFailureIf(boolean condition) {
        ReflectionUtils.invokeMethod(this.buildScanExtension, "publishOnFailureIf", condition);
    }
}

