/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.adapters.develocity;

import com.gradle.develocity.agent.gradle.adapters.BuildCacheConfigurationAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.caching.http.HttpBuildCache;
import org.gradle.caching.local.DirectoryBuildCache;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleBuildCacheConfigurationAdapter
implements BuildCacheConfigurationAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(GradleBuildCacheConfigurationAdapter.class);
    private final BuildCacheConfiguration buildCache;

    public GradleBuildCacheConfigurationAdapter(BuildCacheConfiguration buildCache) {
        this.buildCache = buildCache;
    }

    @Override
    public BuildCacheConfigurationAdapter.LocalBuildCacheAdapter getLocal() {
        return new LocalBuildCache(this.buildCache.getLocal());
    }

    @Override
    @Nullable
    public BuildCacheConfigurationAdapter.RemoteBuildCacheAdapter getRemote() {
        BuildCache remoteConfig = this.buildCache.getRemote();
        if (remoteConfig == null) {
            return null;
        }
        if (remoteConfig instanceof HttpBuildCache) {
            return new HttpRemoteBuildCache((HttpBuildCache)remoteConfig);
        }
        return new ReflectingRemoteBuildCache(remoteConfig);
    }

    private static void warnAboutUnsupportedMethod(String name) {
        LOG.warn("Remote Build Cache instance does not support the {} method", (Object)name);
    }

    private static class ReflectingRemoteBuildCache
    implements BuildCacheConfigurationAdapter.RemoteBuildCacheAdapter {
        private final BuildCache remoteBuildCache;

        private ReflectingRemoteBuildCache(BuildCache remoteBuildCache) {
            this.remoteBuildCache = remoteBuildCache;
        }

        @Override
        public boolean isEnabled() {
            return this.remoteBuildCache.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.remoteBuildCache.setEnabled(enabled);
        }

        @Override
        public boolean isPush() {
            return this.remoteBuildCache.isPush();
        }

        @Override
        public void setPush(boolean push) {
            this.remoteBuildCache.setPush(push);
        }

        @Override
        @Nullable
        public String getUrl() {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("getUrl");
            return null;
        }

        @Override
        public void setUrl(@Nullable String url) {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("setUrl");
        }

        @Override
        @Nullable
        public String getServer() {
            return this.getStringProperty("getServer");
        }

        @Override
        public void setServer(@Nullable String server) {
            this.setStringProperty("setServer", server);
        }

        @Override
        @Nullable
        public String getPath() {
            return this.getStringProperty("getPath");
        }

        @Override
        public void setPath(@Nullable String path) {
            this.setStringProperty("setPath", path);
        }

        @Override
        public boolean getAllowUntrustedServer() {
            return this.getBooleanProperty("getAllowUntrustedServer");
        }

        @Override
        public void setAllowUntrustedServer(boolean allowUntrusted) {
            this.setBooleanProperty("setAllowUntrustedServer", allowUntrusted);
        }

        @Override
        public boolean getAllowInsecureProtocol() {
            return this.getBooleanProperty("getAllowInsecureProtocol");
        }

        @Override
        public void setAllowInsecureProtocol(boolean allowInsecureProtocol) {
            this.setBooleanProperty("setAllowInsecureProtocol", allowInsecureProtocol);
        }

        @Override
        public boolean getUseExpectContinue() {
            return this.getBooleanProperty("getUseExpectContinue");
        }

        @Override
        public void setUseExpectContinue(boolean useExpectContinue) {
            this.setBooleanProperty("setUseExpectContinue", useExpectContinue);
        }

        @Override
        @Nullable
        public Object getUsernameAndPassword() {
            return this.getProperty("getUsernameAndPassword");
        }

        @Override
        public void usernameAndPassword(String username, String password) {
            try {
                Method setter = this.remoteBuildCache.getClass().getDeclaredMethod("usernameAndPassword", String.class, String.class);
                setter.invoke((Object)this.remoteBuildCache, username, password);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("usernameAndPassword");
            }
        }

        private Object getProperty(String name) {
            try {
                Method getter = this.remoteBuildCache.getClass().getDeclaredMethod(name, new Class[0]);
                return getter.invoke((Object)this.remoteBuildCache, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod(name);
                return null;
            }
        }

        private <T> void setProperty(String name, Class<T> type, T value) {
            try {
                Method setter = this.remoteBuildCache.getClass().getDeclaredMethod(name, type);
                setter.invoke((Object)this.remoteBuildCache, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod(name);
            }
        }

        private String getStringProperty(String name) {
            return (String)this.getProperty(name);
        }

        private void setStringProperty(String name, String value) {
            this.setProperty(name, String.class, value);
        }

        private boolean getBooleanProperty(String name) {
            return Boolean.TRUE.equals(this.getProperty(name));
        }

        private void setBooleanProperty(String name, boolean value) {
            this.setProperty(name, Boolean.TYPE, value);
        }
    }

    private static class HttpRemoteBuildCache
    implements BuildCacheConfigurationAdapter.RemoteBuildCacheAdapter {
        private final HttpBuildCache remoteBuildCache;

        private HttpRemoteBuildCache(HttpBuildCache remoteBuildCache) {
            this.remoteBuildCache = remoteBuildCache;
        }

        @Override
        public boolean isEnabled() {
            return this.remoteBuildCache.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.remoteBuildCache.setEnabled(enabled);
        }

        @Override
        public boolean isPush() {
            return this.remoteBuildCache.isPush();
        }

        @Override
        public void setPush(boolean push) {
            this.remoteBuildCache.setPush(push);
        }

        @Override
        @Nullable
        public String getUrl() {
            URI url = this.remoteBuildCache.getUrl();
            return url == null ? null : url.toASCIIString();
        }

        @Override
        public void setUrl(String url) {
            this.remoteBuildCache.setUrl(url);
        }

        @Override
        @Nullable
        public String getServer() {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("getServer");
            return null;
        }

        @Override
        public void setServer(@Nullable String server) {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("setServer");
        }

        @Override
        @Nullable
        public String getPath() {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("getPath");
            return null;
        }

        @Override
        public void setPath(@Nullable String path) {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("setPath");
        }

        @Override
        public boolean getAllowUntrustedServer() {
            return this.remoteBuildCache.isAllowUntrustedServer();
        }

        @Override
        public void setAllowUntrustedServer(boolean allowUntrusted) {
            this.remoteBuildCache.setAllowUntrustedServer(allowUntrusted);
        }

        @Override
        public boolean getAllowInsecureProtocol() {
            return this.remoteBuildCache.isAllowInsecureProtocol();
        }

        @Override
        public void setAllowInsecureProtocol(boolean allowInsecureProtocol) {
            this.remoteBuildCache.setAllowInsecureProtocol(allowInsecureProtocol);
        }

        @Override
        public boolean getUseExpectContinue() {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("getUseExpectContinue");
            return false;
        }

        @Override
        public void setUseExpectContinue(boolean useExpectContinue) {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("setUseExpectContinue");
        }

        @Override
        @Nullable
        public Object getUsernameAndPassword() {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("getUsernameAndPassword");
            return null;
        }

        @Override
        public void usernameAndPassword(String username, String password) {
            GradleBuildCacheConfigurationAdapter.warnAboutUnsupportedMethod("usernameAndPassword");
        }
    }

    private static class LocalBuildCache
    implements BuildCacheConfigurationAdapter.LocalBuildCacheAdapter {
        private final DirectoryBuildCache localBuildCache;

        private LocalBuildCache(DirectoryBuildCache localBuildCache) {
            this.localBuildCache = localBuildCache;
        }

        @Override
        public boolean isEnabled() {
            return this.localBuildCache.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.localBuildCache.setEnabled(enabled);
        }

        @Override
        public boolean isPush() {
            return this.localBuildCache.isPush();
        }

        @Override
        public void setPush(boolean push) {
            this.localBuildCache.setPush(push);
        }

        @Override
        public String getDirectory() {
            return String.valueOf(this.localBuildCache.getDirectory());
        }

        @Override
        public void setDirectory(String directory) {
            this.localBuildCache.setDirectory((Object)directory);
        }

        @Override
        public int getRemoveUnusedEntriesAfterDays() {
            return this.localBuildCache.getRemoveUnusedEntriesAfterDays();
        }

        @Override
        public void setRemoveUnusedEntriesAfterDays(int days) {
            this.localBuildCache.setRemoveUnusedEntriesAfterDays(days);
        }
    }
}

