/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import com.gradle.develocity.agent.gradle.adapters.BuildCacheConfigurationAdapter;
import com.gradle.develocity.agent.gradle.adapters.DevelocityAdapter;
import java.time.Duration;
import java.util.Optional;
import org.gradle.api.provider.ProviderFactory;

final class Overrides {
    static final String DEVELOCITY_URL = "develocity.url";
    static final String GRADLE_ENTERPRISE_URL = "gradle.enterprise.url";
    static final String DEVELOCITY_ALLOW_UNTRUSTED_SERVER = "develocity.allowUntrustedServer";
    static final String GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER = "gradle.enterprise.allowUntrustedServer";
    static final String LOCAL_CACHE_DIRECTORY = "gradle.cache.local.directory";
    static final String LOCAL_CACHE_REMOVE_UNUSED_ENTRIES_AFTER_DAYS = "gradle.cache.local.removeUnusedEntriesAfterDays";
    static final String LOCAL_CACHE_ENABLED = "gradle.cache.local.enabled";
    static final String LOCAL_CACHE_PUSH = "gradle.cache.local.push";
    static final String REMOTE_CACHE_URL = "gradle.cache.remote.url";
    static final String REMOTE_CACHE_SERVER = "gradle.cache.remote.server";
    static final String REMOTE_CACHE_PATH = "gradle.cache.remote.path";
    static final String REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER = "gradle.cache.remote.allowUntrustedServer";
    static final String REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL = "gradle.cache.remote.allowInsecureProtocol";
    static final String REMOTE_CACHE_ENABLED = "gradle.cache.remote.enabled";
    static final String REMOTE_CACHE_PUSH = "gradle.cache.remote.push";
    private final ProviderFactory providers;

    Overrides(ProviderFactory providers) {
        this.providers = providers;
    }

    void configureDevelocity(DevelocityAdapter develocity) {
        Overrides.firstAvailableSysPropertyOrEnvVariable(this.providers, DEVELOCITY_URL, GRADLE_ENTERPRISE_URL).ifPresent(develocity::setServer);
        Overrides.firstAvailableBooleanSysPropertyOrEnvVariable(this.providers, DEVELOCITY_ALLOW_UNTRUSTED_SERVER, GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER).ifPresent(develocity::setAllowUntrustedServer);
    }

    void configureBuildCache(BuildCacheConfigurationAdapter buildCache) {
        this.configureLocalBuildCache(buildCache.getLocal());
        BuildCacheConfigurationAdapter.RemoteBuildCacheAdapter remote = buildCache.getRemote();
        if (remote != null) {
            this.configureRemoteBuildCache(remote);
        }
    }

    private void configureLocalBuildCache(BuildCacheConfigurationAdapter.LocalBuildCacheAdapter local) {
        Overrides.sysPropertyOrEnvVariable(LOCAL_CACHE_DIRECTORY, this.providers).ifPresent(local::setDirectory);
        Overrides.durationSysPropertyOrEnvVariable(LOCAL_CACHE_REMOVE_UNUSED_ENTRIES_AFTER_DAYS, this.providers).ifPresent(v -> local.setRemoveUnusedEntriesAfterDays((int)v.toDays()));
        Overrides.booleanSysPropertyOrEnvVariable(LOCAL_CACHE_ENABLED, this.providers).ifPresent(local::setEnabled);
        Overrides.booleanSysPropertyOrEnvVariable(LOCAL_CACHE_PUSH, this.providers).ifPresent(local::setPush);
    }

    private void configureRemoteBuildCache(BuildCacheConfigurationAdapter.RemoteBuildCacheAdapter remote) {
        Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_URL, this.providers).ifPresent(remote::setUrl);
        Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_SERVER, this.providers).ifPresent(remote::setServer);
        Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_PATH, this.providers).ifPresent(remote::setPath);
        Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER, this.providers).ifPresent(remote::setAllowUntrustedServer);
        Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL, this.providers).ifPresent(remote::setAllowInsecureProtocol);
        Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ENABLED, this.providers).ifPresent(remote::setEnabled);
        Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_PUSH, this.providers).ifPresent(remote::setPush);
    }

    static Optional<String> firstAvailableSysPropertyOrEnvVariable(ProviderFactory providers, String ... sysPropertyNames) {
        for (String sysPropertyName : sysPropertyNames) {
            Optional<String> optValue = Overrides.sysPropertyOrEnvVariable(sysPropertyName, providers);
            if (!optValue.isPresent()) continue;
            return optValue;
        }
        return Optional.empty();
    }

    static Optional<String> sysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.sysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    static Optional<Boolean> firstAvailableBooleanSysPropertyOrEnvVariable(ProviderFactory providers, String ... sysPropertyNames) {
        for (String sysPropertyName : sysPropertyNames) {
            Optional<Boolean> optValue = Overrides.booleanSysPropertyOrEnvVariable(sysPropertyName, providers);
            if (!optValue.isPresent()) continue;
            return optValue;
        }
        return Optional.empty();
    }

    static Optional<Boolean> booleanSysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.booleanSysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    static Optional<Duration> durationSysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.durationSysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    private static String toEnvVarName(String sysPropertyName) {
        return sysPropertyName.toUpperCase().replace('.', '_');
    }
}

