/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import com.gradle.develocity.agent.gradle.adapters.BuildCacheAdapter;
import com.gradle.develocity.agent.gradle.adapters.DevelocityAdapter;
import com.gradle.develocity.agent.gradle.adapters.develocity.DevelocityBuildCacheAdapter;
import com.gradle.develocity.agent.gradle.adapters.enterprise.GradleEnterpriseBuildCacheAdapter;
import java.time.Duration;
import java.util.Optional;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.caching.configuration.AbstractBuildCache;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.caching.http.HttpBuildCache;
import org.gradle.caching.local.DirectoryBuildCache;

final class Overrides {
    static final String DEVELOCITY_URL = "develocity.url";
    static final String GRADLE_ENTERPRISE_URL = "gradle.enterprise.url";
    static final String DEVELOCITY_ALLOW_UNTRUSTED_SERVER = "develocity.allowUntrustedServer";
    static final String GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER = "gradle.enterprise.allowUntrustedServer";
    static final String LOCAL_CACHE_DIRECTORY = "gradle.cache.local.directory";
    static final String LOCAL_CACHE_REMOVE_UNUSED_ENTRIES_AFTER_DAYS = "gradle.cache.local.removeUnusedEntriesAfterDays";
    static final String LOCAL_CACHE_ENABLED = "gradle.cache.local.enabled";
    static final String LOCAL_CACHE_PUSH = "gradle.cache.local.push";
    static final String REMOTE_CACHE_URL = "gradle.cache.remote.url";
    static final String REMOTE_CACHE_SERVER = "gradle.cache.remote.server";
    static final String REMOTE_CACHE_PATH = "gradle.cache.remote.path";
    static final String REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER = "gradle.cache.remote.allowUntrustedServer";
    static final String REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL = "gradle.cache.remote.allowInsecureProtocol";
    static final String REMOTE_CACHE_ENABLED = "gradle.cache.remote.enabled";
    static final String REMOTE_CACHE_PUSH = "gradle.cache.remote.push";
    private final ProviderFactory providers;

    Overrides(ProviderFactory providers) {
        this.providers = providers;
    }

    void configureDevelocity(DevelocityAdapter develocity) {
        Overrides.firstAvailableSysPropertyOrEnvVariable(this.providers, DEVELOCITY_URL, GRADLE_ENTERPRISE_URL).ifPresent(develocity::setServer);
        Overrides.firstAvailableBooleanSysPropertyOrEnvVariable(this.providers, DEVELOCITY_ALLOW_UNTRUSTED_SERVER, GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER).ifPresent(develocity::setAllowUntrustedServer);
    }

    void configureBuildCache(BuildCacheConfiguration buildCache, Class<? extends AbstractBuildCache> develocityCacheClass) {
        buildCache.local(local -> {
            Overrides.sysPropertyOrEnvVariable(LOCAL_CACHE_DIRECTORY, this.providers).ifPresent(arg_0 -> ((DirectoryBuildCache)local).setDirectory(arg_0));
            Overrides.durationSysPropertyOrEnvVariable(LOCAL_CACHE_REMOVE_UNUSED_ENTRIES_AFTER_DAYS, this.providers).ifPresent(v -> local.setRemoveUnusedEntriesAfterDays((int)v.toDays()));
            Overrides.booleanSysPropertyOrEnvVariable(LOCAL_CACHE_ENABLED, this.providers).ifPresent(arg_0 -> ((DirectoryBuildCache)local).setEnabled(arg_0));
            Overrides.booleanSysPropertyOrEnvVariable(LOCAL_CACHE_PUSH, this.providers).ifPresent(arg_0 -> ((DirectoryBuildCache)local).setPush(arg_0));
        });
        if (buildCache.getRemote() instanceof HttpBuildCache) {
            buildCache.remote(HttpBuildCache.class, remote -> {
                Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_URL, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setUrl(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setAllowUntrustedServer(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setAllowInsecureProtocol(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ENABLED, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setEnabled(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_PUSH, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setPush(arg_0));
            });
        } else if (develocityCacheClass.isInstance(buildCache.getRemote())) {
            buildCache.remote(develocityCacheClass, remote -> {
                BuildCacheAdapter adapter = Overrides.createBuildCacheAdapter(remote, develocityCacheClass);
                Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_SERVER, this.providers).ifPresent(adapter::setServer);
                Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_PATH, this.providers).ifPresent(adapter::setPath);
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER, this.providers).ifPresent(adapter::setAllowUntrustedServer);
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL, this.providers).ifPresent(adapter::setAllowInsecureProtocol);
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ENABLED, this.providers).ifPresent(arg_0 -> ((BuildCacheAdapter)adapter).setEnabled(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_PUSH, this.providers).ifPresent(arg_0 -> ((BuildCacheAdapter)adapter).setPush(arg_0));
            });
        }
    }

    private static BuildCacheAdapter createBuildCacheAdapter(AbstractBuildCache cache, Class<? extends AbstractBuildCache> reportedCacheClass) {
        if (reportedCacheClass.getName().toLowerCase().contains("develocity")) {
            return new DevelocityBuildCacheAdapter(cache);
        }
        return new GradleEnterpriseBuildCacheAdapter(cache);
    }

    static Optional<String> firstAvailableSysPropertyOrEnvVariable(ProviderFactory providers, String ... sysPropertyNames) {
        for (String sysPropertyName : sysPropertyNames) {
            Optional<String> optValue = Overrides.sysPropertyOrEnvVariable(sysPropertyName, providers);
            if (!optValue.isPresent()) continue;
            return optValue;
        }
        return Optional.empty();
    }

    static Optional<String> sysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.sysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    static Optional<Boolean> firstAvailableBooleanSysPropertyOrEnvVariable(ProviderFactory providers, String ... sysPropertyNames) {
        for (String sysPropertyName : sysPropertyNames) {
            Optional<Boolean> optValue = Overrides.booleanSysPropertyOrEnvVariable(sysPropertyName, providers);
            if (!optValue.isPresent()) continue;
            return optValue;
        }
        return Optional.empty();
    }

    static Optional<Boolean> booleanSysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.booleanSysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    static Optional<Duration> durationSysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.durationSysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    private static String toEnvVarName(String sysPropertyName) {
        return sysPropertyName.toUpperCase().replace('.', '_');
    }
}

