/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.DupDetector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonReadContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class SmileParserBase
extends ParserMinimalBase {
    protected static final String[] NO_STRINGS = new String[0];
    protected int _formatFeatures;
    protected boolean _mayContainRawBinary;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed;
    protected int _tokenOffsetForTotal;
    protected JsonReadContext _parsingContext;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected byte[] _binaryValue;
    protected JsonParser.NumberType _numberType;
    protected int _numTypesValid = 0;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected int _numberInt;
    protected float _numberFloat;
    protected long _numberLong;
    protected double _numberDouble;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected int _quad3;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<String>>> _smileRecyclerRef = new ThreadLocal();
    protected final SmileBufferRecycler<String> _smileBufferRecycler;

    public SmileParserBase(IOContext ctxt, int parserFeatures, int formatFeatures, ByteQuadsCanonicalizer sym) {
        super(parserFeatures);
        this._formatFeatures = formatFeatures;
        this._ioContext = ctxt;
        this._symbols = sym;
        DupDetector dups = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(parserFeatures) ? DupDetector.rootDetector(this) : null;
        this._parsingContext = JsonReadContext.createRootContext(dups);
        this._textBuffer = ctxt.constructTextBuffer();
        this._smileBufferRecycler = SmileParserBase._smileBufferRecycler();
    }

    protected static final SmileBufferRecycler<String> _smileBufferRecycler() {
        SmileBufferRecycler<String> br;
        SoftReference<SmileBufferRecycler<String>> ref = _smileRecyclerRef.get();
        SmileBufferRecycler<String> smileBufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<String>>(br));
        }
        return br;
    }

    @Override
    public final Version version() {
        return PackageVersion.VERSION;
    }

    public final boolean mayContainRawBinary() {
        return this._mayContainRawBinary;
    }

    @Override
    public final int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public final JsonParser overrideFormatFeatures(int values, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values & mask;
        return this;
    }

    protected abstract void _closeInput() throws IOException;

    protected abstract void _parseNumericValue() throws IOException;

    @Override
    public final JsonLocation getTokenLocation() {
        long total = this._currInputProcessed + (long)this._tokenOffsetForTotal;
        return new JsonLocation(this._ioContext.getSourceReference(), total, -1L, -1, (int)total);
    }

    @Override
    public final JsonLocation getCurrentLocation() {
        long offset = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), offset, -1L, -1, (int)offset);
    }

    @Override
    public final String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            return this._parsingContext.getParent().getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public final void overrideCurrentName(String name) {
        JsonReadContext ctxt = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ctxt = ctxt.getParent();
        }
        try {
            ctxt.setCurrentName(name);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._inputEnd = 0;
            this._symbols.release();
            try {
                this._closeInput();
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    protected final void _releaseBuffers() throws IOException {
        Object[] valueBuf;
        Object[] nameBuf;
        this._textBuffer.releaseBuffers();
        char[] buf = this._nameCopyBuffer;
        if (buf != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(buf);
        }
        if ((nameBuf = this._seenNames) != null && nameBuf.length > 0) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(nameBuf, 0, this._seenNameCount, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((String[])nameBuf);
        }
        if ((valueBuf = this._seenStringValues) != null && valueBuf.length > 0) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(valueBuf, 0, this._seenStringValueCount, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((String[])valueBuf);
        }
        this._releaseBuffers2();
    }

    protected abstract void _releaseBuffers2();

    @Override
    public final boolean isClosed() {
        return this._closed;
    }

    @Override
    public final JsonReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public final boolean isNaN() throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if (this._numberType == JsonParser.NumberType.DOUBLE) {
                double d2 = this._numberDouble;
                return Double.isNaN(d2) || Double.isInfinite(d2);
            }
            if (this._numberType == JsonParser.NumberType.FLOAT) {
                float f2 = this._numberFloat;
                return Float.isNaN(f2) || Float.isInfinite(f2);
            }
        }
        return false;
    }

    @Override
    public final Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue();
        }
        switch (this._numberType) {
            case INT: {
                return this._numberInt;
            }
            case LONG: {
                return this._numberLong;
            }
            case BIG_INTEGER: {
                return this._numberBigInt;
            }
            case FLOAT: {
                return Float.valueOf(this._numberFloat);
            }
            case DOUBLE: {
                return this._numberDouble;
            }
        }
        return this._numberBigDecimal;
    }

    @Override
    public final JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue();
        }
        return this._numberType;
    }

    @Override
    public final int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public final long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public final BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public final float getFloatValue() throws IOException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._numberFloat;
    }

    @Override
    public final double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public final BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected final void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportError("Numeric value (%s) out of range of int", this.getText());
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -2.147483648E9 || (double)this._numberFloat > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected final void convertNumberToLong() throws IOException {
        int v = this._numTypesValid;
        if ((v & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((v & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((v & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((v & 0x20) != 0) {
            if ((double)this._numberFloat < -9.223372036854776E18 || (double)this._numberFloat > 9.223372036854776E18) {
                this.reportOverflowInt();
            }
            this._numberLong = (long)this._numberFloat;
        } else if ((v & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected final void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberFloat).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected final void convertNumberToFloat() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberBigDecimal.floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberBigInt.floatValue();
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = (float)this._numberDouble;
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected final void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberFloat;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected final void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 0x28) != 0) {
            this._numberBigDecimal = NumberInput.parseBigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            String marker = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", marker, this._parsingContext.getStartLocation(this._getSourceReference())), null);
        }
    }

    protected void _reportMismatchedEndMarker(int actCh, char expCh) throws JsonParseException {
        JsonReadContext ctxt = this.getParsingContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)actCh), Character.valueOf(expCh), ctxt.typeDesc(), ctxt.getStartLocation(this._getSourceReference())));
    }

    protected Object _getSourceReference() {
        if (JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.getSourceReference();
        }
        return null;
    }
}

